/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.lowlevel.alsa;

import org.tritonus.lowlevel.alsa.Alsa;
import org.tritonus.lowlevel.alsa.AlsaMixer;
import org.tritonus.share.TDebug;

public class AlsaMixerElement {
    public static final int SND_MIXER_SCHN_UNKNOWN = -1;
    public static final int SND_MIXER_SCHN_FRONT_LEFT = 0;
    public static final int SND_MIXER_SCHN_FRONT_RIGHT = 1;
    public static final int SND_MIXER_SCHN_FRONT_CENTER = 2;
    public static final int SND_MIXER_SCHN_REAR_LEFT = 3;
    public static final int SND_MIXER_SCHN_REAR_RIGHT = 4;
    public static final int SND_MIXER_SCHN_WOOFER = 5;
    public static final int SND_MIXER_SCHN_LAST = 31;
    public static final int SND_MIXER_SCHN_MONO = 0;
    private AlsaMixer m_mixer;
    private long m_lNativeHandle;

    public AlsaMixerElement(AlsaMixer mixer, int nIndex, String strName) {
        this.m_mixer = mixer;
        int nReturn = this.open(this.getMixer(), nIndex, strName);
        if (nReturn < 0) {
            throw new RuntimeException("cannot open");
        }
    }

    private native int open(AlsaMixer var1, int var2, String var3);

    private AlsaMixer getMixer() {
        return this.m_mixer;
    }

    public native String getName();

    public native int getIndex();

    public native boolean isActive();

    public native boolean isPlaybackMono();

    public native boolean hasPlaybackChannel(int var1);

    public native boolean isCaptureMono();

    public native boolean hasCaptureChannel(int var1);

    public native int getCaptureGroup();

    public native boolean hasCommonVolume();

    public native boolean hasPlaybackVolume();

    public native boolean hasPlaybackVolumeJoined();

    public native boolean hasCaptureVolume();

    public native boolean hasCaptureVolumeJoined();

    public native boolean hasCommonSwitch();

    public native boolean hasPlaybackSwitch();

    public native boolean hasPlaybackSwitchJoined();

    public native boolean hasCaptureSwitch();

    public native boolean hasCaptureSwitchJoinded();

    public native boolean hasCaptureSwitchExclusive();

    public native int getPlaybackVolume(int var1);

    public native int getCaptureVolume(int var1);

    public native boolean getPlaybackSwitch(int var1);

    public native boolean getCaptureSwitch(int var1);

    public native void setPlaybackVolume(int var1, int var2);

    public native void setCaptureVolume(int var1, int var2);

    public native void setPlaybackVolumeAll(int var1);

    public native void setCaptureVolumeAll(int var1);

    public native void setPlaybackSwitch(int var1, boolean var2);

    public native void setCaptureSwitch(int var1, boolean var2);

    public native void setPlaybackSwitchAll(boolean var1);

    public native void setCaptureSwitchAll(boolean var1);

    public native void getPlaybackVolumeRange(int[] var1);

    public native void getCaptureVolumeRange(int[] var1);

    public native void setPlaybackVolumeRange(int var1, int var2);

    public native void setCaptureVolumeRange(int var1, int var2);

    public static native String getChannelName(int var0);

    private static native void setTrace(boolean var0);

    static {
        Alsa.loadNativeLibrary();
        if (TDebug.TraceAlsaMixerNative) {
            AlsaMixerElement.setTrace(true);
        }
    }
}

