/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.lowlevel.dsp;

import org.tritonus.lowlevel.dsp.Filter;

public class FIR
implements Filter {
    private int m_nLength;
    private float[] m_afCoefficients;
    private float[] m_afBuffer;
    private int m_nBufferIndex;

    public FIR(float[] afCoefficients) {
        this.m_nLength = afCoefficients.length;
        this.m_afCoefficients = new float[this.m_nLength];
        System.arraycopy(afCoefficients, 0, this.m_afCoefficients, 0, this.m_nLength);
        this.m_afBuffer = new float[this.m_nLength];
        this.m_nBufferIndex = 0;
    }

    public float process(float fInput) {
        this.m_nBufferIndex = (this.m_nBufferIndex + 1) % this.m_nLength;
        this.m_afBuffer[this.m_nBufferIndex] = fInput;
        int nBufferIndex = this.m_nBufferIndex;
        float fOutput = 0.0f;
        for (int i = 0; i < this.m_nLength; ++i) {
            fOutput += this.m_afCoefficients[i] * this.m_afBuffer[nBufferIndex];
            if (--nBufferIndex >= 0) continue;
            nBufferIndex += this.m_nLength;
        }
        return fOutput;
    }

    private int getLength() {
        return this.m_nLength;
    }

    public double getFrequencyResponse(double dOmega) {
        double dReal = 0.0;
        double dImag = 0.0;
        for (int i = 0; i < this.getLength(); ++i) {
            dReal += (double)this.m_afCoefficients[i] * Math.cos((double)i * dOmega);
            dImag += (double)this.m_afCoefficients[i] * Math.sin((double)i * dOmega);
        }
        double dResult = Math.sqrt(dReal * dReal + dImag * dImag);
        return dResult;
    }

    public double getPhaseResponse(double dOmega) {
        double dReal = 0.0;
        double dImag = 0.0;
        for (int i = 0; i < this.getLength(); ++i) {
            dReal += (double)this.m_afCoefficients[i] * Math.cos((double)i * dOmega);
            dImag += (double)this.m_afCoefficients[i] * Math.sin((double)i * dOmega);
        }
        double dResult = Math.atan2(dImag, dReal);
        return dResult;
    }
}

