/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.midi.device.alsa;

import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import org.tritonus.lowlevel.alsa.AlsaSeq;
import org.tritonus.lowlevel.alsa.AlsaSeqEvent;
import org.tritonus.share.TDebug;

public class AlsaMidiOut {
    private AlsaSeq m_alsaSeq;
    private int m_nSourcePort;
    private int m_nQueue;
    private boolean m_bImmediately;
    private boolean m_bHandleMetaMessages;
    private AlsaSeqEvent m_event = new AlsaSeqEvent();

    public AlsaMidiOut(AlsaSeq aSequencer, int nSourcePort, int nQueue) {
        this(aSequencer, nSourcePort, nQueue, false);
    }

    public AlsaMidiOut(AlsaSeq aSequencer, int nSourcePort) {
        this(aSequencer, nSourcePort, -1, true);
    }

    private AlsaMidiOut(AlsaSeq aSequencer, int nSourcePort, int nQueue, boolean bImmediately) {
        if (TDebug.TraceAlsaMidiOut) {
            TDebug.out("AlsaMidiOut.<init>(AlsaSeq, int, int, boolean): begin");
        }
        this.m_alsaSeq = aSequencer;
        this.m_nSourcePort = nSourcePort;
        this.m_nQueue = nQueue;
        this.m_bImmediately = bImmediately;
        this.m_bHandleMetaMessages = false;
        if (TDebug.TraceAlsaMidiOut) {
            TDebug.out("AlsaMidiOut.<init>(AlsaSeq, int, int, boolean): end");
        }
    }

    private AlsaSeq getAlsaSeq() {
        return this.m_alsaSeq;
    }

    private int getSourcePort() {
        return this.m_nSourcePort;
    }

    private int getQueue() {
        return this.m_nQueue;
    }

    private boolean getImmediately() {
        return this.m_bImmediately;
    }

    public boolean getHandleMetaMessages() {
        return this.m_bHandleMetaMessages;
    }

    public void setHandleMetaMessages(boolean bHandleMetaMessages) {
        this.m_bHandleMetaMessages = bHandleMetaMessages;
    }

    public synchronized void enqueueMessage(MidiMessage event, long lTick) {
        if (TDebug.TraceAlsaMidiOut) {
            TDebug.out("AlsaMidiOut.enqueueMessage(): begin");
        }
        if (event instanceof ShortMessage) {
            this.enqueueShortMessage((ShortMessage)event, lTick);
        } else if (event instanceof SysexMessage) {
            this.enqueueSysexMessage((SysexMessage)event, lTick);
        } else if (event instanceof MetaMessage && this.getHandleMetaMessages()) {
            this.enqueueMetaMessage((MetaMessage)event, lTick);
        }
        if (TDebug.TraceAlsaMidiOut) {
            TDebug.out("AlsaMidiOut.enqueueMessage(): end");
        }
    }

    private void enqueueShortMessage(ShortMessage shortMessage, long lTime) {
        int nChannel = shortMessage.getChannel();
        block0 : switch (shortMessage.getCommand()) {
            case 128: {
                this.sendNoteOffEvent(lTime, nChannel, shortMessage.getData1(), shortMessage.getData2());
                break;
            }
            case 144: {
                this.sendNoteOnEvent(lTime, nChannel, shortMessage.getData1(), shortMessage.getData2());
                break;
            }
            case 160: {
                this.sendKeyPressureEvent(lTime, nChannel, shortMessage.getData1(), shortMessage.getData2());
                break;
            }
            case 176: {
                this.sendControlChangeEvent(lTime, nChannel, shortMessage.getData1(), shortMessage.getData2());
                break;
            }
            case 192: {
                this.sendProgramChangeEvent(lTime, nChannel, shortMessage.getData1());
                break;
            }
            case 208: {
                this.sendChannelPressureEvent(lTime, nChannel, shortMessage.getData1());
                break;
            }
            case 224: {
                this.sendPitchBendEvent(lTime, nChannel, AlsaMidiOut.get14bitValue(shortMessage.getData1(), shortMessage.getData2()));
                break;
            }
            case 240: {
                switch (shortMessage.getStatus()) {
                    case 241: {
                        this.sendMTCEvent(lTime, shortMessage.getData1());
                        break block0;
                    }
                    case 242: {
                        this.sendSongPositionPointerEvent(lTime, AlsaMidiOut.get14bitValue(shortMessage.getData1(), shortMessage.getData2()));
                        break block0;
                    }
                    case 243: {
                        this.sendSongSelectEvent(lTime, shortMessage.getData1());
                        break block0;
                    }
                    case 246: {
                        this.sendTuneRequestEvent(lTime);
                        break block0;
                    }
                    case 248: {
                        this.sendMidiClockEvent(lTime);
                        break block0;
                    }
                    case 250: {
                        this.sendStartEvent(lTime);
                        break block0;
                    }
                    case 251: {
                        this.sendContinueEvent(lTime);
                        break block0;
                    }
                    case 252: {
                        this.sendStopEvent(lTime);
                        break block0;
                    }
                    case 254: {
                        this.sendActiveSensingEvent(lTime);
                        break block0;
                    }
                    case 255: {
                        this.sendSystemResetEvent(lTime);
                        break block0;
                    }
                }
                TDebug.out("AlsaMidiOut.enqueueShortMessage(): UNKNOWN EVENT TYPE: " + shortMessage.getStatus());
                break;
            }
            default: {
                TDebug.out("AlsaMidiOut.enqueueShortMessage(): UNKNOWN EVENT TYPE: " + shortMessage.getStatus());
            }
        }
    }

    private static int get14bitValue(int nLSB, int nMSB) {
        return nLSB & 0x7F | (nMSB & 0x7F) << 7;
    }

    private void sendNoteOffEvent(long lTime, int nChannel, int nNote, int nVelocity) {
        this.sendNoteEvent(7, lTime, nChannel, nNote, nVelocity);
    }

    private void sendNoteOnEvent(long lTime, int nChannel, int nNote, int nVelocity) {
        this.sendNoteEvent(6, lTime, nChannel, nNote, nVelocity);
    }

    private void sendNoteEvent(int nType, long lTime, int nChannel, int nNote, int nVelocity) {
        this.setCommon(nType, 0, lTime);
        this.m_event.setNote(nChannel, nNote, nVelocity, 0, 0);
        this.sendEvent();
    }

    private void sendKeyPressureEvent(long lTime, int nChannel, int nNote, int nPressure) {
        this.sendControlEvent(8, lTime, nChannel, nNote, nPressure);
    }

    private void sendControlChangeEvent(long lTime, int nChannel, int nControl, int nValue) {
        this.sendControlEvent(10, lTime, nChannel, nControl, nValue);
    }

    private void sendProgramChangeEvent(long lTime, int nChannel, int nProgram) {
        this.sendControlEvent(11, lTime, nChannel, 0, nProgram);
    }

    private void sendChannelPressureEvent(long lTime, int nChannel, int nPressure) {
        this.sendControlEvent(12, lTime, nChannel, 0, nPressure);
    }

    private void sendPitchBendEvent(long lTime, int nChannel, int nPitch) {
        this.sendControlEvent(13, lTime, nChannel, 0, nPitch);
    }

    private void sendControlEvent(int nType, long lTime, int nChannel, int nParam, int nValue) {
        this.setCommon(nType, 0, lTime);
        this.m_event.setControl(nChannel, nParam, nValue);
        this.sendEvent();
    }

    private void sendMTCEvent(long lTime, int nData) {
        this.sendControlEvent(22, lTime, 0, 0, nData);
    }

    private void sendSongPositionPointerEvent(long lTime, int nPosition) {
        this.sendControlEvent(20, lTime, 0, 0, nPosition);
    }

    private void sendSongSelectEvent(long lTime, int nSong) {
        this.sendControlEvent(21, lTime, 0, 0, nSong);
    }

    private void sendTuneRequestEvent(long lTime) {
        this.sendEvent(40, lTime);
    }

    private void sendMidiClockEvent(long lTime) {
        this.sendQueueControlEvent(36, lTime, 0, 0, 0L);
    }

    private void sendStartEvent(long lTime) {
        this.sendQueueControlEvent(30, lTime, 0, 0, 0L);
    }

    private void sendContinueEvent(long lTime) {
        this.sendQueueControlEvent(31, lTime, 0, 0, 0L);
    }

    private void sendStopEvent(long lTime) {
        this.sendQueueControlEvent(32, lTime, 0, 0, 0L);
    }

    private void sendActiveSensingEvent(long lTime) {
        this.sendEvent(42, lTime);
    }

    private void sendSystemResetEvent(long lTime) {
        this.sendEvent(41, lTime);
    }

    private void sendQueueControlEvent(int nType, long lTime, int nQueue, int nValue, long lControlTime) {
        this.setCommon(nType, 0, lTime);
        this.m_event.setQueueControl(nQueue, nValue, lControlTime);
        this.sendEvent();
    }

    private void sendEvent(int nType, long lTime) {
        this.setCommon(nType, 0, lTime);
        this.sendEvent();
    }

    private void enqueueSysexMessage(SysexMessage message, long lTick) {
        byte[] abData = message.getMessage();
        int nLength = message.getLength();
        if ((abData[0] & 0xFF) == 240) {
            this.sendVarEvent(130, lTick, abData, 0, nLength);
        } else {
            this.sendVarEvent(130, lTick, abData, 1, nLength - 1);
        }
    }

    private void enqueueMetaMessage(MetaMessage message, long lTick) {
        byte[] abData = message.getData();
        byte[] abTransferData = new byte[abData.length + 1];
        abTransferData[0] = (byte)message.getType();
        System.arraycopy(abData, 0, abTransferData, 1, abData.length);
        this.sendVarEvent(139, lTick, abTransferData, 0, abTransferData.length);
    }

    private void sendVarEvent(int nType, long lTime, byte[] abData, int nOffset, int nLength) {
        this.setCommon(nType, 4, lTime);
        this.m_event.setVar(abData, 0, nLength);
        this.sendEvent();
    }

    private void setCommon(int nType, int nAdditionalFlags, long lTime) {
        if (this.getImmediately()) {
            if (TDebug.TraceAlsaMidiOut) {
                TDebug.out("AlsaMidiOut.enqueueShortMessage(): sending noteoff message (immediately)");
            }
            this.m_event.setCommon(nType, 3 | nAdditionalFlags, 0, 253, 0L, 0, this.getSourcePort(), 254, 253);
        } else {
            if (TDebug.TraceAlsaMidiOut) {
                TDebug.out("AlsaMidiOut.enqueueShortMessage(): sending noteoff message (timed)");
            }
            this.m_event.setCommon(nType, 0 | nAdditionalFlags, 0, this.getQueue(), lTime, 0, this.getSourcePort(), 254, 253);
        }
    }

    private void sendEvent() {
        this.getAlsaSeq().eventOutput(this.m_event);
        this.getAlsaSeq().drainOutput();
    }
}

