/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5242;
import net.minecraft.class_7157;
import top.gregtao.concerto.ConcertoServer;
import top.gregtao.concerto.config.CacheManager;
import top.gregtao.concerto.http.kugou.KuGouMusicApiClient;
import top.gregtao.concerto.http.netease.NeteaseCloudApiClient;
import top.gregtao.concerto.http.qq.QQMusicApiClient;
import top.gregtao.concerto.network.MusicDataPacket;
import top.gregtao.concerto.network.ServerMusicNetworkHandler;
import top.gregtao.concerto.network.room.ServerMusicAgent;
import top.gregtao.concerto.util.ConcertoRunner;
import top.gregtao.concerto.util.TextUtil;

public class ConcertoServerCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 access, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"concerto-server").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"audit").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"uuid", (ArgumentType)class_5242.method_27643()).executes(context -> {
            UUID uuid = class_5242.method_27645((CommandContext)context, (String)"uuid");
            ServerMusicNetworkHandler.passAudition((class_1657)((class_2168)context.getSource()).method_44023(), uuid);
            return 0;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reject").then(class_2170.method_9244((String)"uuid", (ArgumentType)class_5242.method_27643()).executes(context -> {
            UUID uuid = class_5242.method_27645((CommandContext)context, (String)"uuid");
            ServerMusicNetworkHandler.rejectAudition((class_1657)((class_2168)context.getSource()).method_44023(), uuid);
            return 0;
        }))).then(class_2170.method_9247((String)"all").executes(context -> {
            ServerMusicNetworkHandler.rejectAll((class_1657)((class_2168)context.getSource()).method_44023());
            return 0;
        })))).then(class_2170.method_9247((String)"list").then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            ConcertoRunner.run(() -> {
                int i;
                int page = IntegerArgumentType.getInteger((CommandContext)context, (String)"page");
                Map<UUID, MusicDataPacket> map = ServerMusicNetworkHandler.WAIT_AUDITION;
                Iterator<Map.Entry<UUID, MusicDataPacket>> iterator = map.entrySet().iterator();
                page = Math.min(page, (int)Math.ceil((float)map.size() / 10.0f));
                TextUtil.commandMessageServer((CommandContext<class_2168>)context, TextUtil.PAGE_SPLIT);
                for (i = 1; i < 10 * (page - 1); ++i) {
                    if (!iterator.hasNext()) continue;
                    iterator.next();
                }
                for (i = 10 * (page - 1); i < Math.min(10 * page, map.size()) && iterator.hasNext(); ++i) {
                    Map.Entry<UUID, MusicDataPacket> entry = iterator.next();
                    MusicDataPacket packet = entry.getValue();
                    TextUtil.commandMessageServer((CommandContext<class_2168>)context, (class_2561)class_2561.method_43470((String)(i + 1 + ". ")).method_10852(ConcertoServerCommand.chatMessageBuilder(entry.getKey(), packet.from, packet.music.getMeta().title())));
                }
                TextUtil.commandMessageServer((CommandContext<class_2168>)context, TextUtil.PAGE_SPLIT);
            });
            return 0;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> source.method_9259(2))).executes(context -> {
            ConcertoServer.reload();
            return 0;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload-cookie").requires(source -> source.method_9259(2))).executes(context -> {
            NeteaseCloudApiClient.INSTANCE.readCookie();
            QQMusicApiClient.INSTANCE.readCookie();
            KuGouMusicApiClient.INSTANCE.readCookie();
            return 0;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clean-cache").requires(source -> source.method_9259(2))).executes(context -> {
            CacheManager.cleanAllCache();
            return 0;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"fetch-radios").requires(source -> source.method_9259(0))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (player != null) {
                ServerMusicNetworkHandler.sendS2CPresetRadiosPacket(player);
            }
            return 0;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"agent").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"reset").executes(context -> {
            ServerMusicAgent.INSTANCE.reset();
            return 0;
        }))).then(class_2170.method_9247((String)"cut").executes(context -> {
            ServerMusicAgent.INSTANCE.schedulePlayNext(0, false);
            return 0;
        }))).then(class_2170.method_9247((String)"stop").executes(context -> {
            ServerMusicAgent.INSTANCE.stop();
            return 0;
        }))).then(class_2170.method_9247((String)"start").executes(context -> {
            ServerMusicAgent.INSTANCE.start();
            return 0;
        }))));
    }

    public static class_2561 chatMessageBuilder(UUID uuid, String name, String title) {
        return class_2561.method_43469((String)"concerto.audit.message", (Object[])new Object[]{name, title}).method_10852((class_2561)class_2561.method_43470((String)"  [")).method_10852((class_2561)class_2561.method_43471((String)"concerto.accept").method_10862(TextUtil.getRunCommandStyle("/concerto-server audit " + String.valueOf(uuid)).method_10977(class_124.field_1060))).method_10852((class_2561)class_2561.method_43470((String)"]")).method_10852((class_2561)class_2561.method_43470((String)"  [")).method_10852((class_2561)class_2561.method_43471((String)"concerto.reject").method_10862(TextUtil.getRunCommandStyle("/concerto-server audit reject " + String.valueOf(uuid)).method_10977(class_124.field_1061))).method_10852((class_2561)class_2561.method_43470((String)"]"));
    }
}

