/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import net.minecraft.class_746;
import top.gregtao.concerto.ConcertoClient;
import top.gregtao.concerto.network.ClientMusicNetworkHandler;
import top.gregtao.concerto.network.room.MusicRoom;

public class MusicRoomCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 access) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"musicroom").then(ClientCommandManager.literal((String)"create").executes(context -> {
            class_746 player = ((FabricClientCommandSource)context.getSource()).getPlayer();
            if (MusicRoomCommand.checkServerAvailable(player) && MusicRoomCommand.checkLocal(player)) {
                MusicRoom.clientCreate();
            }
            return 0;
        }))).then(ClientCommandManager.literal((String)"join").then(ClientCommandManager.argument((String)"uuid", (ArgumentType)StringArgumentType.string()).executes(context -> {
            class_746 player = ((FabricClientCommandSource)context.getSource()).getPlayer();
            if (MusicRoomCommand.checkServerAvailable(player) && MusicRoomCommand.checkLocal(player)) {
                MusicRoom.clientJoin(StringArgumentType.getString((CommandContext)context, (String)"uuid"));
            }
            return 0;
        })))).then(ClientCommandManager.literal((String)"quit").executes(context -> {
            switch (ConcertoClient.clientState) {
                case MUSIC_AGENT: {
                    ClientMusicNetworkHandler.musicAgentQuit();
                    break;
                }
                case MUSIC_ROOM: {
                    MusicRoom.clientQuit();
                }
            }
            return 0;
        }))).then(ClientCommandManager.literal((String)"members").executes(context -> {
            if (MusicRoom.CLIENT_ROOM != null) {
                ((FabricClientCommandSource)context.getSource()).getPlayer().method_7353((class_2561)class_2561.method_43469((String)"concerto.room.members", (Object[])new Object[]{MusicRoom.CLIENT_ROOM.owner, String.join((CharSequence)",", MusicRoom.CLIENT_ROOM.members.keySet())}), false);
            }
            return 0;
        }))).then(ClientCommandManager.literal((String)"op").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(context -> {
            MusicRoom.clientSetOp(StringArgumentType.getString((CommandContext)context, (String)"player"));
            return 0;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"agent").then(ClientCommandManager.literal((String)"join").executes(context -> {
            class_746 player = ((FabricClientCommandSource)context.getSource()).getPlayer();
            if (MusicRoomCommand.checkServerAvailable(player) && MusicRoomCommand.checkLocal(player)) {
                ClientMusicNetworkHandler.musicAgentJoin();
            }
            return 0;
        }))).then(ClientCommandManager.literal((String)"quit").executes(context -> {
            class_746 player = ((FabricClientCommandSource)context.getSource()).getPlayer();
            if (MusicRoomCommand.checkServerAvailable(player) && MusicRoomCommand.checkAgent(player)) {
                ClientMusicNetworkHandler.musicAgentQuit();
            }
            return 0;
        }))).then(ClientCommandManager.literal((String)"query").executes(context -> {
            class_746 player = ((FabricClientCommandSource)context.getSource()).getPlayer();
            if (MusicRoomCommand.checkServerAvailable(player) && MusicRoomCommand.checkAgent(player)) {
                ClientMusicNetworkHandler.musicAgentQuery();
            }
            return 0;
        }))).then(ClientCommandManager.literal((String)"add").executes(context -> {
            class_746 player = ((FabricClientCommandSource)context.getSource()).getPlayer();
            if (MusicRoomCommand.checkServerAvailable(player) && MusicRoomCommand.checkAgent(player) && !ClientMusicNetworkHandler.musicAgentAddCurrentMusic()) {
                player.method_7353((class_2561)class_2561.method_43471((String)"concerto.not_playing_music"), false);
            }
            return 0;
        }))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"vote").executes(context -> {
            class_746 player = ((FabricClientCommandSource)context.getSource()).getPlayer();
            if (MusicRoomCommand.checkServerAvailable(player) && MusicRoomCommand.checkAgent(player)) {
                ClientMusicNetworkHandler.musicAgentNewVote();
            }
            return 0;
        })).then(ClientCommandManager.argument((String)"vote", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            class_746 player = ((FabricClientCommandSource)context.getSource()).getPlayer();
            if (MusicRoomCommand.checkServerAvailable(player) && MusicRoomCommand.checkAgent(player)) {
                ClientMusicNetworkHandler.musicAgentVote(BoolArgumentType.getBool((CommandContext)context, (String)"vote"));
            }
            return 0;
        })))));
    }

    public static boolean checkServerAvailable(class_746 player) {
        if (!ConcertoClient.isServerAvailable()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"concerto.not_available"), false);
            return false;
        }
        return true;
    }

    public static boolean checkLocal(class_746 player) {
        if (ConcertoClient.clientState == ConcertoClient.ClientState.LOCAL) {
            return true;
        }
        player.method_7353((class_2561)class_2561.method_43471((String)"concerto.agent.occupied"), false);
        return false;
    }

    public static boolean checkAgent(class_746 player) {
        if (ConcertoClient.clientState == ConcertoClient.ClientState.MUSIC_AGENT) {
            return true;
        }
        player.method_7353((class_2561)class_2561.method_43471((String)"concerto.agent.not_in"), false);
        return false;
    }
}

