/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.config;

import java.net.CookieManager;
import java.net.URI;
import java.util.List;
import java.util.Map;
import top.gregtao.concerto.ConcertoServer;
import top.gregtao.concerto.config.ConfigFile;
import top.gregtao.concerto.util.TextUtil;

public class CookieFile
extends ConfigFile {
    public CookieFile(String name) {
        super("Concerto/cache/" + name + ".cookie");
    }

    public void write(CookieManager manager) {
        try {
            StringBuilder builder = new StringBuilder();
            for (URI uri : manager.getCookieStore().getURIs()) {
                builder.append(TextUtil.toBase64(uri.toString())).append(":").append(TextUtil.toBase64(String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)manager.get(uri, Map.of()).get("Cookie")))).append('\n');
            }
            this.write(builder.toString());
        }
        catch (Exception e) {
            ConcertoServer.LOGGER.error("Error writing cookie", (Throwable)e);
        }
    }

    public void read(CookieManager manager) {
        try {
            String[] lines;
            String baseRaw = this.read();
            if (baseRaw.isEmpty()) {
                return;
            }
            for (String line : lines = baseRaw.split("\n")) {
                String[] args = line.split(":");
                if (args.length != 2) continue;
                URI uri = new URI(TextUtil.fromBase64(args[0]));
                String raw = TextUtil.fromBase64(args[1]);
                List<String> cookies = List.of(raw.split("\n"));
                manager.put(uri, Map.of("Set-Cookie", cookies));
            }
        }
        catch (Exception e) {
            ConcertoServer.LOGGER.error("Error reading cookie", (Throwable)e);
        }
    }

    public String readAsHeader() {
        try {
            String baseRaw = this.read();
            if (baseRaw.isEmpty()) {
                return "";
            }
            String[] lines = baseRaw.split("\n");
            StringBuilder result = new StringBuilder();
            for (String line : lines) {
                String[] args = line.split(":");
                if (args.length != 2) continue;
                String raw = TextUtil.fromBase64(args[1]).replace("\n", "; ");
                result.append(raw);
            }
            return result.toString();
        }
        catch (Exception e) {
            ConcertoServer.LOGGER.error("Error reading cookie as header", (Throwable)e);
            return "";
        }
    }
}

