/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import org.jetbrains.annotations.NotNull;
import top.gregtao.concerto.ConcertoClient;
import top.gregtao.concerto.http.HttpApiClient;

public class HttpClientInputStream
extends InputStream {
    private final String url;
    private final HttpApiClient connection;
    private InputStream in;
    private int szBytes = 0;
    private int readBytesTotal;

    public HttpClientInputStream(String url, HttpApiClient client, int startBytePos) throws IOException {
        this.readBytesTotal = startBytePos;
        this.url = url;
        this.connection = client;
        HttpResponse<InputStream> response = this.connection.open().url(this.url).openStream();
        if (response.statusCode() != 206 && response.statusCode() != 200) {
            throw new IOException(String.valueOf(response.statusCode()));
        }
        response.headers().firstValueAsLong("Content-Length").ifPresent(num -> {
            this.szBytes = (int)num;
        });
        this.in = response.body();
    }

    public HttpClientInputStream(String url, HttpApiClient client) throws IOException {
        this(url, client, 0);
    }

    private void disconnect() throws IOException {
        this.in.close();
    }

    private void connect() throws IOException {
        HttpResponse<InputStream> response = this.connection.open().url(this.url).setHeader("Range", "bytes=" + this.readBytesTotal + "-" + this.szBytes).openStream();
        if (response.statusCode() != 206 && response.statusCode() != 200) {
            String message = response.statusCode() + " - cannot access to url: " + this.url;
            ConcertoClient.LOGGER.error(message);
            throw new IOException(message);
        }
        this.in = response.body();
    }

    private void reconnect() {
        ConcertoClient.LOGGER.warn("Connection Reset: Trying reconnecting to {}", (Object)this.url);
        try {
            this.disconnect();
            this.connect();
        }
        catch (IOException e) {
            ConcertoClient.LOGGER.error("Failed to reconnect!");
        }
    }

    @Override
    public int read() throws IOException {
        if (this.readBytesTotal >= this.szBytes) {
            this.close();
            return -1;
        }
        int k = -1;
        int counter = 0;
        while (k == -1 && ++counter <= 3) {
            try {
                k = this.in.read();
                if (k != -1) continue;
                this.reconnect();
            }
            catch (IOException e) {
                this.reconnect();
            }
        }
        if (k != -1) {
            ++this.readBytesTotal;
        }
        return k;
    }

    @Override
    public int read(byte @NotNull [] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte @NotNull [] b, int off, int len) throws IOException {
        if (this.readBytesTotal >= this.szBytes) {
            this.close();
            return -1;
        }
        for (int i = off; i < b.length && i < len + off; ++i) {
            int b1 = this.read();
            if (b1 == -1) {
                return i - off + 1;
            }
            b[i] = (byte)(b1 & 0xFF);
        }
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        int k = 0;
        while (--n >= 0L && this.read() != -1) {
            ++k;
        }
        return k;
    }

    @Override
    public int available() {
        return this.szBytes - this.readBytesTotal;
    }

    @Override
    public void close() throws IOException {
        this.disconnect();
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

