/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.music;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import top.gregtao.concerto.api.CacheableMusic;
import top.gregtao.concerto.api.JsonParsable;
import top.gregtao.concerto.api.LazyLoadable;
import top.gregtao.concerto.api.MusicSourceNotFoundException;
import top.gregtao.concerto.api.WithMetaData;
import top.gregtao.concerto.config.MusicCacheManager;
import top.gregtao.concerto.music.lyrics.Lyrics;
import top.gregtao.concerto.music.meta.music.MusicMetaData;
import top.gregtao.concerto.util.FileUtil;
import top.gregtao.concerto.util.Pair;

public abstract class Music
implements JsonParsable<Music>,
LazyLoadable,
WithMetaData {
    private boolean isMetaLoaded = false;
    private MusicMetaData musicMetaData = null;

    public InputStream getMusicSourceOrNull() {
        Music music = this;
        if (music instanceof CacheableMusic) {
            CacheableMusic cacheable = (CacheableMusic)((Object)music);
            File child = MusicCacheManager.INSTANCE.getChild(cacheable);
            try {
                return child == null ? this.getMusicSource() : FileUtil.createBuffered(new FileInputStream(child));
            }
            catch (FileNotFoundException | MusicSourceNotFoundException e) {
                return null;
            }
        }
        try {
            return this.getMusicSource();
        }
        catch (MusicSourceNotFoundException e) {
            return null;
        }
    }

    public Pair<Lyrics, Lyrics> getLyrics() throws IOException {
        return null;
    }

    @Override
    public MusicMetaData getMeta() {
        if (!this.isLoaded()) {
            this.load();
            this.isMetaLoaded = true;
        }
        return this.musicMetaData;
    }

    @Override
    public void load() {
        this.isMetaLoaded = true;
    }

    public void setMusicMeta(MusicMetaData musicMetaData) {
        this.musicMetaData = musicMetaData;
        this.isMetaLoaded = true;
    }

    @Override
    public boolean isLoaded() {
        return this.isMetaLoaded;
    }

    @Override
    public boolean isMetaLoaded() {
        return this.isMetaLoaded;
    }

    public abstract InputStream getMusicSource() throws MusicSourceNotFoundException;

    public abstract String getLink();
}

