/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.network;

import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1132;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;
import top.gregtao.concerto.ConcertoClient;
import top.gregtao.concerto.api.MusicJsonParsers;
import top.gregtao.concerto.command.ShareMusicCommand;
import top.gregtao.concerto.config.ClientConfig;
import top.gregtao.concerto.config.PresetPlaylistsConfig;
import top.gregtao.concerto.music.Music;
import top.gregtao.concerto.network.ConcertoNetworking;
import top.gregtao.concerto.network.MusicDataPacket;
import top.gregtao.concerto.network.room.MusicRoom;
import top.gregtao.concerto.player.MusicPlayer;
import top.gregtao.concerto.player.MusicPlayerHandler;
import top.gregtao.concerto.screen.MusicAuditionScreen;
import top.gregtao.concerto.screen.PresetRadiosScreen;
import top.gregtao.concerto.util.ConcertoRunner;
import top.gregtao.concerto.util.JsonUtil;
import top.gregtao.concerto.util.TextUtil;

public class ClientMusicNetworkHandler {
    public static final Map<UUID, MusicDataPacket> WAIT_CONFIRMATION = new HashMap<UUID, MusicDataPacket>();

    public static void register() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ConcertoNetworking.MUSIC_DATA, ClientMusicNetworkHandler::musicDataReceiver);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ConcertoNetworking.HANDSHAKE, ClientMusicNetworkHandler::playerJoinHandshake);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ConcertoNetworking.AUDITION_SYNC, ClientMusicNetworkHandler::auditionDataSyncReceiver);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ConcertoNetworking.MUSIC_ROOM, MusicRoom::clientReceiver);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ConcertoNetworking.PRESET_RADIOS, ClientMusicNetworkHandler::presetRadiosReceiver);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ConcertoNetworking.MUSIC_AGENT, ClientMusicNetworkHandler::musicAgentMusicReceiver);
    }

    public static void removeFirst() {
        Iterator<Map.Entry<UUID, MusicDataPacket>> iterator = WAIT_CONFIRMATION.entrySet().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        iterator.next();
        iterator.remove();
    }

    public static void sendC2SMusicData(MusicDataPacket packet) {
        if (!ConcertoClient.isServerAvailable()) {
            class_746 player = class_310.method_1551().field_1724;
            JsonObject object = MusicJsonParsers.to(packet.music, false);
            if (player != null && object != null) {
                String code = "Concerto:Share:" + Base64.getEncoder().encodeToString(object.toString().getBytes(StandardCharsets.UTF_8));
                if (packet.to.equals("@a")) {
                    player.field_3944.method_45729(code);
                } else {
                    player.field_3944.method_45730("msg " + packet.to + " \"" + code + "\"");
                }
            }
            return;
        }
        if (packet.isS2C) {
            throw new RuntimeException("Not an C2S music data packet");
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            throw new RuntimeException("You are NULL, bro :)");
        }
        packet.music.load();
        class_2540 buf = packet.toPacket(player.method_5477().getString());
        ClientPlayNetworking.send((class_2960)ConcertoNetworking.MUSIC_DATA, (class_2540)buf);
    }

    public static void accept(class_1657 player, UUID uuid, class_310 client) {
        if (!WAIT_CONFIRMATION.containsKey(uuid)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"concerto.confirm.not_found"), false);
        } else {
            class_3222 from;
            MusicDataPacket packet = WAIT_CONFIRMATION.get(uuid);
            class_1132 server = client.method_1576();
            if (server != null && (from = server.method_3760().method_14566(packet.from)) != null) {
                from.method_7353((class_2561)class_2561.method_43469((String)"concerto.confirm.accept_response", (Object[])new Object[]{player.method_5477().getString()}), false);
            }
            MusicPlayer.INSTANCE.playTempMusic(packet.music);
            WAIT_CONFIRMATION.remove(uuid);
            player.method_7353((class_2561)class_2561.method_43471((String)"concerto.confirm.accept"), false);
        }
    }

    public static void rejectAll(class_1657 player, class_310 client) {
        class_1132 server = client.method_1576();
        WAIT_CONFIRMATION.forEach((arg_0, arg_1) -> ClientMusicNetworkHandler.lambda$rejectAll$0((MinecraftServer)server, player, arg_0, arg_1));
        WAIT_CONFIRMATION.clear();
        player.method_7353((class_2561)class_2561.method_43471((String)"concerto.confirm.reject"), false);
    }

    public static void reject(class_1657 player, UUID uuid, class_310 client) {
        if (!WAIT_CONFIRMATION.containsKey(uuid)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"concerto.confirm.not_found"), false);
        } else {
            class_3222 from;
            MusicDataPacket packet = WAIT_CONFIRMATION.get(uuid);
            class_1132 server = client.method_1576();
            if (server != null && (from = server.method_3760().method_14566(packet.from)) != null) {
                from.method_7353((class_2561)class_2561.method_43469((String)"concerto.confirm.reject_response", (Object[])new Object[]{player.method_5477().getString()}), false);
            }
            WAIT_CONFIRMATION.remove(uuid);
            player.method_7353((class_2561)class_2561.method_43471((String)"concerto.confirm.reject"), false);
        }
    }

    public static void addToWaitList(class_310 client, MusicDataPacket packet, class_1657 self) {
        UUID uuid = UUID.randomUUID();
        WAIT_CONFIRMATION.put(uuid, packet);
        if (WAIT_CONFIRMATION.size() > 300) {
            ClientMusicNetworkHandler.removeFirst();
        }
        ConcertoRunner.run(() -> {
            if (ClientConfig.INSTANCE.options.confirmAfterReceived) {
                self.method_7353(TextUtil.PAGE_SPLIT, false);
                self.method_7353(ShareMusicCommand.chatMessageBuilder(uuid, packet.from, packet.music.getMeta().title()), false);
                self.method_7353(TextUtil.PAGE_SPLIT, false);
            } else {
                ClientMusicNetworkHandler.accept(self, uuid, client);
            }
        });
    }

    public static void musicDataReceiver(class_310 client, class_634 handler, class_2540 buf, PacketSender packetSender) {
        try {
            MusicDataPacket packet = MusicDataPacket.fromPacket(buf, true);
            class_746 self = client.field_1724;
            if (packet != null && packet.music != null && self != null) {
                ClientMusicNetworkHandler.addToWaitList(client, packet, (class_1657)self);
            } else {
                ConcertoClient.LOGGER.warn("Received an unknown music data packet");
            }
        }
        catch (Exception e) {
            ConcertoClient.LOGGER.warn("Received an unsafe music data packet");
        }
    }

    public static void playerJoinHandshake(class_310 client, class_634 handler, class_2540 buf, PacketSender packetSender) {
        String str = buf.method_10800(524272);
        if (!str.startsWith("CONCERTO:")) {
            return;
        }
        String[] args = str.split(":");
        if (args.length < 3) {
            return;
        }
        if (args[1].equals("CallJoin")) {
            String playerName = args[2];
            class_746 player = client.field_1724;
            if (player != null && playerName.equals(player.method_5477().getString())) {
                ConcertoClient.serverAvailable = true;
                ConcertoClient.LOGGER.info("Concerto has been installed in this server");
                if (args.length > 3 && !client.method_1542() && args[3].equals("Invite")) {
                    if (ClientConfig.INSTANCE.options.joinAgentWhenInvited) {
                        player.field_3944.method_45730("musicroom agent join");
                    } else {
                        player.method_7353(TextUtil.PAGE_SPLIT, false);
                        player.method_7353((class_2561)class_2561.method_43471((String)"concerto.agent.invite").method_10852((class_2561)class_2561.method_43470((String)"  [")).method_10852((class_2561)class_2561.method_43471((String)"concerto.accept").method_10862(TextUtil.getRunCommandStyle("/musicroom agent join").method_10977(class_124.field_1060))).method_10852((class_2561)class_2561.method_43470((String)"]")), false);
                        player.method_7353(TextUtil.PAGE_SPLIT, false);
                    }
                }
            }
        }
    }

    public static void auditionDataSyncReceiver(class_310 client, class_634 handler, class_2540 buf, PacketSender packetSender) {
        String str = buf.method_10800(524272);
        String[] args = str.split(";");
        if (args.length != 3) {
            return;
        }
        try {
            Music music;
            if (args[0].equals("DEL")) {
                MusicAuditionScreen.WAIT_AUDITION.remove(UUID.fromString(args[1]));
            } else if (args[0].equals("ADD") && (music = MusicJsonParsers.from(JsonUtil.from(args[2]))) != null) {
                MusicAuditionScreen.WAIT_AUDITION.put(UUID.fromString(args[1]), music);
            }
        }
        catch (IllegalArgumentException e) {
            ConcertoClient.LOGGER.error("Received an AuditionSyncDataPacket with illegal UUID: {}", (Object)args[1]);
        }
    }

    public static void presetRadiosReceiver(class_310 client, class_634 handler, class_2540 buf, PacketSender packetSender) {
        String str = buf.method_10800(524272);
        ConcertoRunner.run(() -> {
            ConcertoClient.presetRadios = PresetPlaylistsConfig.fromJson(str).stream().filter(playlist -> playlist.getList().stream().allMatch(MusicDataPacket::isMusicSafe)).toList();
        }, () -> {
            class_437 patt0$temp;
            if (client != null && (patt0$temp = client.field_1755) instanceof PresetRadiosScreen) {
                PresetRadiosScreen screen = (PresetRadiosScreen)patt0$temp;
                screen.reset();
            }
        });
    }

    public static void musicAgentSender(String command) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(command);
        ClientPlayNetworking.send((class_2960)ConcertoNetworking.MUSIC_AGENT, (class_2540)buf);
    }

    public static void musicAgentJoin() {
        ClientMusicNetworkHandler.musicAgentSender("Join");
        ConcertoClient.clientState = ConcertoClient.ClientState.MUSIC_AGENT;
    }

    public static void musicAgentQuit() {
        ClientMusicNetworkHandler.musicAgentSender("Quit");
        ConcertoClient.clientState = ConcertoClient.ClientState.LOCAL;
    }

    public static void musicAgentNewVote() {
        ClientMusicNetworkHandler.musicAgentSender("Vote:New");
    }

    public static void musicAgentQuery() {
        ClientMusicNetworkHandler.musicAgentSender("Query");
    }

    public static void musicAgentVote(boolean vote) {
        ClientMusicNetworkHandler.musicAgentSender("Vote:" + (vote ? "1" : "0"));
    }

    public static boolean musicAgentAddCurrentMusic() {
        return MusicPlayerHandler.INSTANCE.getCurrentMusic() != null && ClientMusicNetworkHandler.musicAgentAddMusic(MusicPlayerHandler.INSTANCE.getCurrentMusic());
    }

    public static boolean musicAgentAddMusic(Music music) {
        JsonObject object = MusicJsonParsers.to(music);
        if (object == null) {
            return false;
        }
        ClientMusicNetworkHandler.musicAgentSender("Add:" + TextUtil.toBase64(object.toString()));
        return true;
    }

    public static void musicAgentMusicReceiver(class_310 client, class_634 handler, class_2540 buf, PacketSender packetSender) {
        String str = buf.method_10800(524272);
        if (ConcertoClient.clientState != ConcertoClient.ClientState.MUSIC_AGENT) {
            return;
        }
        ConcertoRunner.run(() -> {
            if (str.equals("Stop")) {
                MusicPlayer.INSTANCE.stop();
            } else {
                Music music = MusicJsonParsers.from(TextUtil.fromBase64(str));
                if (music != null) {
                    MusicPlayer.INSTANCE.playTempMusic(music);
                }
            }
        });
    }

    private static /* synthetic */ void lambda$rejectAll$0(MinecraftServer server, class_1657 player, UUID uuid, MusicDataPacket packet) {
        class_3222 from;
        if (server != null && (from = server.method_3760().method_14566(packet.from)) != null) {
            from.method_7353((class_2561)class_2561.method_43469((String)"concerto.confirm.reject_response", (Object[])new Object[]{player.method_5477().getString()}), false);
        }
    }
}

