/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.network.room;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_634;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;
import top.gregtao.concerto.ConcertoClient;
import top.gregtao.concerto.ConcertoServer;
import top.gregtao.concerto.api.DynamicPath;
import top.gregtao.concerto.api.MusicJsonParsers;
import top.gregtao.concerto.config.ServerConfig;
import top.gregtao.concerto.music.Music;
import top.gregtao.concerto.music.SharedMusic;
import top.gregtao.concerto.network.ConcertoNetworking;
import top.gregtao.concerto.network.MusicDataPacket;
import top.gregtao.concerto.player.MusicPlayer;
import top.gregtao.concerto.util.TextUtil;

public class MusicRoom {
    public static final Map<UUID, MusicRoom> ROOMS = new HashMap<UUID, MusicRoom>();
    public final UUID uuid;
    public String owner;
    public Music music;
    public boolean pause = true;
    public Map<String, Integer> members = new HashMap<String, Integer>();
    public int permission = 0;
    public static MusicRoom CLIENT_ROOM;

    public MusicRoom(String creator) {
        this.uuid = UUID.randomUUID();
        this.owner = creator;
        this.members.put(creator, 3);
    }

    public MusicRoom(UUID uuid) {
        this.uuid = uuid;
    }

    public String buildArgs(boolean withMusic) {
        return String.valueOf(this.uuid) + ":" + this.owner + ":" + (this.pause ? "1" : "0") + ":" + String.join((CharSequence)",", this.members.entrySet().stream().map(entry -> (String)entry.getKey() + "+" + String.valueOf(entry.getValue())).toList()) + ":" + (!withMusic || this.music == null ? "null" : TextUtil.toBase64(MusicJsonParsers.to(this.music).toString()));
    }

    public void send2EachMember(String command, String args, String ignores, MinecraftServer server) {
        List<String> strings = Arrays.stream(ignores.split(",")).toList();
        this.members.forEach((member, permission) -> {
            if (!strings.contains(member)) {
                MusicRoom.serverSender(command, args, server.method_3760().method_14566(member));
            }
        });
    }

    public void serverOnRemove(String name, MinecraftServer server) throws IllegalAccessException {
        if (this.members.get(name) < 2) {
            throw new IllegalAccessException("No permission");
        }
        this.send2EachMember("REM", "", "", server);
    }

    public void serverOnJoin(String name, MinecraftServer server) {
        this.members.put(name, 1);
        this.send2EachMember("UPD", this.buildArgs(false), "", server);
    }

    public void serverOnQuit(String name, MinecraftServer server) {
        this.members.remove(name);
        this.send2EachMember("UPD", this.buildArgs(false), "", server);
    }

    public void serverOnUpdate(String name, String music, MinecraftServer server) throws IllegalAccessException {
        if (this.members.get(name) < 2) {
            throw new IllegalAccessException("No permission");
        }
        this.music = MusicJsonParsers.from(TextUtil.fromBase64(music));
        this.pause = false;
        this.send2EachMember("UPD", this.buildArgs(true), name, server);
    }

    public void serverOnPause(String name, boolean pause, MinecraftServer server) throws IllegalAccessException {
        if (this.members.get(name) < 2) {
            throw new IllegalAccessException("No permission");
        }
        this.pause = pause;
        this.send2EachMember("UPD", this.buildArgs(false), name, server);
    }

    public void serverOnSetOp(String name, class_3222 player, String target, MinecraftServer server) throws IllegalAccessException {
        if (this.members.get(name) < 3 || name.equals(target)) {
            throw new IllegalAccessException("No permission");
        }
        Integer permission = this.members.get(target);
        if (permission == null) {
            player.method_43496((class_2561)class_2561.method_43471((String)"concerto.room.update.fail"));
        } else if (permission == 2) {
            this.members.put(target, 1);
            player.method_43496((class_2561)class_2561.method_43469((String)"concerto.room.de_op", (Object[])new Object[]{target}));
        } else {
            this.members.put(target, 2);
            player.method_43496((class_2561)class_2561.method_43469((String)"concerto.room.op", (Object[])new Object[]{target}));
        }
        this.send2EachMember("UPD", this.buildArgs(false), name, server);
    }

    public static void serverSender(String command, String args, class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(command + ":" + args);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ConcertoNetworking.MUSIC_ROOM, (class_2540)buf);
    }

    public static void serverReceiver(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender sender) {
        String[] args = buf.method_19772().split(":");
        switch (args[0]) {
            case "CRE": {
                if (!player.method_5687(ServerConfig.INSTANCE.options.musicRoomCommandPermission)) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"concerto.room.permission_denied"));
                    break;
                }
                MusicRoom room = new MusicRoom(player.method_5477().getString());
                ROOMS.put(room.uuid, room);
                MusicRoom.serverSender("JOI", room.buildArgs(false), player);
                player.method_43496((class_2561)class_2561.method_43469((String)"concerto.room.create", (Object[])new Object[]{room.uuid.toString()}));
                break;
            }
            case "REM": {
                try {
                    UUID uuid1 = UUID.fromString(args[1]);
                    MusicRoom room = Objects.requireNonNull(ROOMS.get(uuid1));
                    room.serverOnRemove(player.method_5477().getString(), server);
                    ROOMS.remove(uuid1);
                    player.method_43496((class_2561)class_2561.method_43469((String)"concerto.room.remove", (Object[])new Object[]{uuid1.toString()}));
                }
                catch (IllegalAccessException | IllegalArgumentException | NullPointerException e) {
                    ConcertoServer.LOGGER.warn(e.toString());
                    player.method_43496((class_2561)class_2561.method_43471((String)"concerto.room.remove.fail"));
                }
                break;
            }
            case "JOI": {
                try {
                    UUID uuid1 = UUID.fromString(args[1]);
                    MusicRoom room = Objects.requireNonNull(ROOMS.get(uuid1));
                    room.serverOnJoin(player.method_5477().getString(), server);
                    MusicRoom.serverSender("JOI", room.buildArgs(true), player);
                    player.method_43496((class_2561)class_2561.method_43469((String)"concerto.room.join", (Object[])new Object[]{uuid1.toString()}));
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    ConcertoServer.LOGGER.warn(e.toString());
                    player.method_43496((class_2561)class_2561.method_43471((String)"concerto.room.join.fail"));
                }
                break;
            }
            case "QUI": {
                try {
                    UUID uuid1 = UUID.fromString(args[1]);
                    MusicRoom room = Objects.requireNonNull(ROOMS.get(uuid1));
                    room.serverOnQuit(player.method_5477().getString(), server);
                    MusicRoom.serverSender("QUI", uuid1.toString(), player);
                    player.method_43496((class_2561)class_2561.method_43469((String)"concerto.room.quit", (Object[])new Object[]{uuid1.toString()}));
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    ConcertoServer.LOGGER.warn(e.toString());
                    player.method_43496((class_2561)class_2561.method_43471((String)"concerto.room.quit.fail"));
                }
                break;
            }
            case "UPD": {
                try {
                    UUID uuid1 = UUID.fromString(args[1]);
                    MusicRoom room = Objects.requireNonNull(ROOMS.get(uuid1));
                    room.serverOnUpdate(player.method_5477().getString(), args[2], server);
                }
                catch (IllegalAccessException | IllegalArgumentException | NullPointerException e) {
                    ConcertoServer.LOGGER.warn(e.toString());
                    player.method_43496((class_2561)class_2561.method_43471((String)"concerto.room.update.fail"));
                }
                break;
            }
            case "PAU": {
                try {
                    UUID uuid1 = UUID.fromString(args[1]);
                    MusicRoom room = Objects.requireNonNull(ROOMS.get(uuid1));
                    room.serverOnPause(player.method_5477().getString(), args[2].equals("1"), server);
                }
                catch (IllegalAccessException | IllegalArgumentException | NullPointerException e) {
                    ConcertoServer.LOGGER.warn(e.toString());
                    player.method_43496((class_2561)class_2561.method_43471((String)"concerto.room.update.fail"));
                }
                break;
            }
            case "SOP": {
                try {
                    UUID uuid1 = UUID.fromString(args[1]);
                    MusicRoom room = Objects.requireNonNull(ROOMS.get(uuid1));
                    room.serverOnSetOp(player.method_5477().getString(), player, args[2], server);
                    break;
                }
                catch (IllegalAccessException | IllegalArgumentException | NullPointerException e) {
                    ConcertoServer.LOGGER.warn(e.toString());
                    player.method_43496((class_2561)class_2561.method_43471((String)"concerto.room.update.fail"));
                }
            }
        }
    }

    public static void clientCreate() {
        if (CLIENT_ROOM != null) {
            return;
        }
        MusicRoom.clientSender("CRE", "");
    }

    public static void clientRemove() {
        if (CLIENT_ROOM == null) {
            return;
        }
        MusicRoom.clientSender("REM", MusicRoom.CLIENT_ROOM.uuid.toString());
    }

    public static void clientJoin(String uuid) {
        if (CLIENT_ROOM != null) {
            return;
        }
        MusicRoom.clientSender("JOI", uuid);
    }

    public static void clientQuit() {
        if (CLIENT_ROOM == null) {
            return;
        }
        if (MusicRoom.CLIENT_ROOM.permission == 3) {
            MusicRoom.clientRemove();
        } else {
            MusicRoom.clientSender("QUI", MusicRoom.CLIENT_ROOM.uuid.toString());
        }
    }

    public static void clientUpdate(Music music) {
        Music music1;
        if (CLIENT_ROOM == null || MusicRoom.CLIENT_ROOM.permission < 2) {
            return;
        }
        if (!MusicDataPacket.isMusicSafe(music)) {
            if (class_310.method_1551().field_1724 != null) {
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)"concerto.share.unsafe"), false);
            }
            return;
        }
        if (music instanceof DynamicPath) {
            DynamicPath dynamicPath = (DynamicPath)((Object)music);
            String path = dynamicPath.getLastRawPath();
            music1 = new SharedMusic(path, music.getMeta(), dynamicPath.getLastLyrics(), dynamicPath.getLastSubLyrics());
        } else {
            music1 = music;
        }
        MusicRoom.clientSender("UPD", MusicRoom.CLIENT_ROOM.uuid.toString() + ":" + TextUtil.toBase64(MusicJsonParsers.to(music1).toString()));
    }

    public static void clientPause(boolean pause) {
        if (CLIENT_ROOM == null || MusicRoom.CLIENT_ROOM.permission < 2) {
            return;
        }
        MusicRoom.clientSender("PAU", MusicRoom.CLIENT_ROOM.uuid.toString() + (pause ? ":1" : ":0"));
    }

    public static void clientSetOp(String target) {
        if (CLIENT_ROOM == null || MusicRoom.CLIENT_ROOM.permission < 3) {
            return;
        }
        MusicRoom.clientSender("SOP", MusicRoom.CLIENT_ROOM.uuid.toString() + ":" + target);
        MusicRoom.CLIENT_ROOM.members.put(target, 2);
    }

    public static void clientSender(String command, String args) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(command + ":" + args);
        ClientPlayNetworking.send((class_2960)ConcertoNetworking.MUSIC_ROOM, (class_2540)buf);
    }

    public static void clientReceiver(class_310 client, class_634 handler, class_2540 buf, PacketSender packetSender) {
        if (client.field_1724 == null) {
            return;
        }
        class_746 player = client.field_1724;
        String[] args = buf.method_19772().split(":");
        switch (args[0]) {
            case "REM": {
                CLIENT_ROOM = null;
                ConcertoClient.clientState = ConcertoClient.ClientState.LOCAL;
                break;
            }
            case "JOI": {
                try {
                    UUID uuid1 = UUID.fromString(args[1]);
                    CLIENT_ROOM = new MusicRoom(uuid1);
                    client.field_1774.method_1455(uuid1.toString());
                    MusicRoom.CLIENT_ROOM.owner = args[2];
                    MusicRoom.CLIENT_ROOM.members = new HashMap<String, Integer>();
                    Arrays.stream(args[4].split(",")).forEach(str -> {
                        String[] strings = str.split("\\+");
                        int permission = Integer.parseInt(strings[1]);
                        MusicRoom.CLIENT_ROOM.members.put(strings[0], permission);
                        if (strings[0].equals(player.method_5477().getString())) {
                            MusicRoom.CLIENT_ROOM.permission = permission;
                        }
                    });
                    MusicRoom.CLIENT_ROOM.pause = args[3].equals("1");
                    if (!args[5].equals("null")) {
                        MusicRoom.CLIENT_ROOM.music = MusicJsonParsers.from(TextUtil.fromBase64(args[5]));
                        MusicPlayer.INSTANCE.playTempMusic(MusicRoom.CLIENT_ROOM.music, () -> {
                            if (MusicRoom.CLIENT_ROOM.pause) {
                                MusicPlayer.INSTANCE.pause();
                            }
                        });
                    }
                    ConcertoClient.clientState = ConcertoClient.ClientState.MUSIC_ROOM;
                    player.method_7353((class_2561)class_2561.method_43469((String)"concerto.room.join", (Object[])new Object[]{uuid1.toString()}), false);
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    ConcertoClient.LOGGER.warn(e.toString());
                    player.method_7353((class_2561)class_2561.method_43471((String)"concerto.room.join.fail"), false);
                }
                break;
            }
            case "QUI": {
                if (CLIENT_ROOM == null) break;
                try {
                    UUID uuid1 = UUID.fromString(args[1]);
                    if (MusicRoom.CLIENT_ROOM.uuid.compareTo(uuid1) == 0) {
                        CLIENT_ROOM = null;
                    }
                    ConcertoClient.clientState = ConcertoClient.ClientState.LOCAL;
                    player.method_7353((class_2561)class_2561.method_43469((String)"concerto.room.quit", (Object[])new Object[]{uuid1.toString()}), false);
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    ConcertoClient.LOGGER.warn(e.toString());
                    player.method_7353((class_2561)class_2561.method_43471((String)"concerto.room.join.fail"), false);
                }
                break;
            }
            case "UPD": {
                if (CLIENT_ROOM == null) break;
                try {
                    UUID uuid1 = UUID.fromString(args[1]);
                    if (MusicRoom.CLIENT_ROOM.uuid.compareTo(uuid1) != 0) break;
                    MusicRoom.CLIENT_ROOM.owner = args[2];
                    MusicRoom.CLIENT_ROOM.members = new HashMap<String, Integer>();
                    Arrays.stream(args[4].split(",")).forEach(str -> {
                        String[] strings = str.split("\\+");
                        int permission = Integer.parseInt(strings[1]);
                        MusicRoom.CLIENT_ROOM.members.put(strings[0], permission);
                        if (strings[0].equals(player.method_5477().getString())) {
                            MusicRoom.CLIENT_ROOM.permission = permission;
                        }
                    });
                    MusicRoom.CLIENT_ROOM.pause = args[3].equals("1");
                    if (!args[5].equals("null")) {
                        MusicRoom.CLIENT_ROOM.music = MusicJsonParsers.from(TextUtil.fromBase64(args[5]));
                        MusicPlayer.INSTANCE.playTempMusic(MusicRoom.CLIENT_ROOM.music, () -> {
                            if (MusicRoom.CLIENT_ROOM.pause) {
                                MusicPlayer.INSTANCE.pause();
                            }
                        });
                        break;
                    }
                    if (MusicRoom.CLIENT_ROOM.pause) {
                        MusicPlayer.INSTANCE.musicRoomPause();
                        break;
                    }
                    MusicPlayer.INSTANCE.musicRoomResume();
                    break;
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    ConcertoClient.LOGGER.warn(e.toString());
                    player.method_7353((class_2561)class_2561.method_43471((String)"concerto.room.update.fail"), false);
                }
            }
        }
    }
}

