/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.player.streamplayer.stream;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import top.gregtao.concerto.player.streamplayer.enums.Status;
import top.gregtao.concerto.player.streamplayer.stream.StreamPlayer;
import top.gregtao.concerto.player.streamplayer.stream.StreamPlayerEvent;
import top.gregtao.concerto.player.streamplayer.stream.StreamPlayerListener;

public class StreamPlayerEventLauncher
implements Callable<String> {
    private final Logger logger;
    private Status playerState = Status.NOT_SPECIFIED;
    private int encodedStreamPosition = -1;
    private Object description = null;
    private List<StreamPlayerListener> listeners = null;
    private StreamPlayer source = null;

    public StreamPlayerEventLauncher(StreamPlayer source, Status playerStatus, int encodedStreamPosition, Object description, List<StreamPlayerListener> listeners) {
        this.source = source;
        this.playerState = playerStatus;
        this.encodedStreamPosition = encodedStreamPosition;
        this.description = description;
        this.listeners = listeners;
        this.logger = source.getLogger();
    }

    @Override
    public String call() {
        if (this.listeners != null) {
            this.listeners.forEach(listener -> listener.statusUpdated(new StreamPlayerEvent(this.source, this.playerState, this.encodedStreamPosition, this.description)));
        }
        this.logger.log(Level.INFO, "Stream player Status -> " + String.valueOf((Object)this.playerState));
        return "OK";
    }
}

