/*
 * Decompiled with CFR 0.152.
 */
package top.gregtao.concerto.util;

import java.util.Optional;
import java.util.function.Function;

public class Optionals {
    @SafeVarargs
    public static <T, R> Optional<R> firstOf(Optional<T> opt, Function<? super T, ? extends R> ... mapper) {
        if (opt.isEmpty()) {
            return Optional.empty();
        }
        for (Function<T, R> function : mapper) {
            R res = function.apply(opt.get());
            if (res == null) continue;
            return Optional.of(res);
        }
        return Optional.empty();
    }

    @SafeVarargs
    public static <T, R> Optional<R> flatFirstOf(Optional<T> opt, Function<? super T, ? extends Optional<R>> ... mapper) {
        if (opt.isEmpty()) {
            return Optional.empty();
        }
        for (Function<T, Optional<Optional<R>>> function : mapper) {
            Optional<R> res = function.apply(opt.get());
            if (!res.isPresent()) continue;
            return res;
        }
        return Optional.empty();
    }
}

