/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.quickStash;

import java.util.Map;
import me.tomqnto.quickStash.PlayerSettings;
import me.tomqnto.quickStash.QuickStashCommand;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.DyeColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.EnderChest;
import org.bukkit.block.ShulkerBox;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class QuickStash
extends JavaPlugin
implements Listener {
    private static QuickStash instance;
    private PlayerSettings playerSettings;

    public void onEnable() {
        instance = this;
        this.playerSettings = new PlayerSettings();
        this.playerSettings.load();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().broadcast((Component)Component.text((String)"quickstash started"));
        this.getCommand("quickstash").setExecutor((CommandExecutor)new QuickStashCommand(this.playerSettings));
    }

    public static QuickStash getInstance() {
        return instance;
    }

    @EventHandler
    public void onPunchBlock(PlayerInteractEvent event) {
        if (event.getAction().isLeftClick()) {
            BlockState blockState;
            boolean isSurvivalSneaking;
            Player player = event.getPlayer();
            Block block = event.getClickedBlock();
            ItemStack item = player.getItemInHand();
            this.playerSettings.setDefaultsIfDoesntExist(player);
            boolean isBlockNull = event.getClickedBlock() == null;
            boolean isCreativeNotSneaking = player.getGameMode() == GameMode.CREATIVE && !player.isSneaking();
            boolean bl = isSurvivalSneaking = player.getGameMode() == GameMode.SURVIVAL && player.isSneaking();
            if (!this.playerSettings.isQSEnabled(player)) {
                return;
            }
            if (isBlockNull || isCreativeNotSneaking || isSurvivalSneaking || item.getType() == Material.AIR) {
                return;
            }
            String itemText = "<bold>x" + item.getAmount() + " " + this.capitalize(item.getType().name().replace("_", " ") + "</bold>");
            if (item.hasItemMeta() && item.getItemMeta().hasCustomName()) {
                itemText = "<bold>x" + item.getAmount() + " " + this.legacyColorsToMiniMessage(item.getItemMeta().getDisplayName()) + "<reset>";
            }
            if ((blockState = block.getState()) instanceof Chest) {
                Chest chest = (Chest)blockState;
                player.setItemInHand(null);
                chest.getBlockInventory().addItem(new ItemStack[]{item});
                if (this.playerSettings.areNotificationsEnabled(player)) {
                    player.sendRichMessage("Stashed " + itemText + " in the clicked <#b87333>Chest!");
                }
                player.playSound(player.getLocation(), Sound.BLOCK_CHEST_CLOSE, 0.4f, 1.0f);
                return;
            }
            blockState = block.getState();
            if (blockState instanceof Barrel) {
                Barrel barrel = (Barrel)blockState;
                player.setItemInHand(null);
                barrel.getInventory().addItem(new ItemStack[]{item});
                if (this.playerSettings.areNotificationsEnabled(player)) {
                    player.sendRichMessage("Stashed " + itemText + " in the clicked <#8b4513>Barrel!");
                }
                player.playSound(player.getLocation(), Sound.BLOCK_BARREL_CLOSE, 0.4f, 1.0f);
                return;
            }
            blockState = block.getState();
            if (blockState instanceof ShulkerBox) {
                ShulkerBox shulkerBox = (ShulkerBox)blockState;
                player.setItemInHand(null);
                shulkerBox.getInventory().addItem(new ItemStack[]{item});
                String color = this.getShulkerColor(shulkerBox);
                if (this.playerSettings.areNotificationsEnabled(player)) {
                    player.sendRichMessage("Stashed " + itemText + " in the clicked " + color + "Shulker Box!");
                }
                player.playSound(player.getLocation(), Sound.BLOCK_SHULKER_BOX_OPEN, 0.4f, 1.0f);
                return;
            }
            if (block.getState() instanceof EnderChest) {
                player.setItemInHand(null);
                player.getEnderChest().addItem(new ItemStack[]{item});
                if (this.playerSettings.areNotificationsEnabled(player)) {
                    player.sendRichMessage("Stashed " + itemText + " in your <light_purple>Ender Chest!");
                }
                player.playSound(player.getLocation(), Sound.BLOCK_ENDER_CHEST_CLOSE, 0.4f, 1.0f);
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        BlockState state = event.getBlock().getState();
        if (!this.playerSettings.isQSEnabled(player) || player.getItemInHand().getType() == Material.AIR) {
            return;
        }
        if (player.getGameMode() == GameMode.CREATIVE && (state instanceof Chest || state instanceof EnderChest || state instanceof ShulkerBox || state instanceof Barrel) && player.isSneaking()) {
            event.setCancelled(true);
        }
    }

    public String capitalize(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        String[] words = input.split(" ");
        StringBuilder sb = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            sb.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase()).append(" ");
        }
        return sb.toString().trim();
    }

    public String getShulkerColor(ShulkerBox shulkerBox) {
        DyeColor color = shulkerBox.getColor();
        if (color == null) {
            return "<#A066C5>";
        }
        Map miniMessageColors = Map.ofEntries(Map.entry(DyeColor.WHITE, "<white>"), Map.entry(DyeColor.ORANGE, "<gold>"), Map.entry(DyeColor.MAGENTA, "<light_purple>"), Map.entry(DyeColor.LIGHT_BLUE, "<aqua>"), Map.entry(DyeColor.YELLOW, "<yellow>"), Map.entry(DyeColor.LIME, "<green>"), Map.entry(DyeColor.PINK, "<#ff69b4>"), Map.entry(DyeColor.GRAY, "<gray>"), Map.entry(DyeColor.LIGHT_GRAY, "<#d3d3d3>"), Map.entry(DyeColor.CYAN, "<dark_aqua>"), Map.entry(DyeColor.PURPLE, "<dark_purple>"), Map.entry(DyeColor.BLUE, "<blue>"), Map.entry(DyeColor.BROWN, "<#8b4513>"), Map.entry(DyeColor.GREEN, "<dark_green>"), Map.entry(DyeColor.RED, "<red>"), Map.entry(DyeColor.BLACK, "<black>"));
        return miniMessageColors.getOrDefault(color, "<white>");
    }

    public String legacyColorsToMiniMessage(String legacyText) {
        TextComponent component = LegacyComponentSerializer.legacySection().deserialize(legacyText);
        return (String)MiniMessage.miniMessage().serialize((Component)component);
    }
}

