/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.quickStash;

import java.io.File;
import java.io.IOException;
import me.tomqnto.quickStash.QuickStash;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PlayerSettings {
    private File file;
    private YamlConfiguration config;

    public PlayerSettings() {
        this.setConfig();
    }

    public void setConfig() {
        this.file = new File(QuickStash.getInstance().getDataFolder(), "player_settings.yml");
        this.config = new YamlConfiguration();
        if (!this.file.exists()) {
            QuickStash.getInstance().saveResource("player_settings.yml", false);
        }
        this.load();
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }

    public void load() {
        try {
            this.config.load(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void enableQS(Player player) {
        this.getConfig().set(player.getName() + ".enabled", (Object)true);
        this.save();
    }

    public void disableQS(Player player) {
        this.getConfig().set(player.getName() + ".enabled", (Object)false);
        this.save();
    }

    public void enableNotifications(Player player) {
        this.getConfig().set(player.getName() + ".allow-notifications", (Object)true);
        this.save();
    }

    public void disableNotifications(Player player) {
        this.getConfig().set(player.getName() + ".allow-notifications", (Object)false);
        this.save();
    }

    public boolean isQSEnabled(Player player) {
        return this.getConfig().getBoolean(player.getName() + ".enabled");
    }

    public boolean areNotificationsEnabled(Player player) {
        return this.getConfig().getBoolean(player.getName() + ".allow-notifications");
    }

    public boolean hasPlayer(Player player) {
        return this.getConfig().contains(player.getName());
    }

    public void setDefaultsIfDoesntExist(Player player) {
        if (!this.hasPlayer(player)) {
            this.enableQS(player);
            this.enableNotifications(player);
        }
    }
}

