/*
 * Decompiled with CFR 0.152.
 */
package me.tomqnto.quickStash;

import java.util.List;
import java.util.stream.Collectors;
import me.tomqnto.quickStash.PlayerSettings;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickStashCommand
implements CommandExecutor,
TabCompleter {
    private final PlayerSettings ps;
    private final String helpString = "<gold><bold>                 \u23d0 QuickStash Commands \u23d0                </bold></gold><br><gray>---------------------------------------------------</gray><br><br><gray>(Click to run)<br><click:run_command:'/qs enable'><hover:show_text:'<green>Enable QuickStash'><green>/qs enable</green></hover></click> <white>\u00bb Turns on the QuickStash feature</white><br><click:run_command:'/qs disable'><hover:show_text:'<red>Disable QuickStash'><red>/qs disable</red></hover></click> <white>\u00bb Turns off the QuickStash feature</white><br><click:run_command:'/qs sounds enable'><hover:show_text:'<green>Enable sound effects when stashing'><green>/qs sounds enable</green></hover></click> <white>\u00bb Turns on stash sounds</white><br><click:run_command:'/qs notifications enable'><hover:show_text:'<green>Enable stash notifications in chat'><green>/qs notifications enable</green></hover></click> <white>\u00bb Turns on stash notifications</white><br><click:run_command:'/qs notifications disable'><hover:show_text:'<red>Disable stash notifications in chat'><red>/qs notifications disable</red></hover></click> <white>\u00bb Turns off stash notifications</white><br><br><gray>---------------------------------------------------</gray><br><br>";
    private final String prefix = "<gold><bold>[<reset><yellow>QuickStash<gold><bold>]<reset> ";

    public QuickStashCommand(PlayerSettings ps) {
        this.ps = ps;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] args) {
        if (!(sender instanceof Player)) {
            sender.sendRichMessage("<gold><bold>[<reset><yellow>QuickStash<gold><bold>]<reset> <red>Only players are allowed to execute this command");
            return true;
        }
        Player player = (Player)sender;
        this.ps.setDefaultsIfDoesntExist(player);
        if (args.length == 0 || args[0].equals("help")) {
            player.sendRichMessage("<gold><bold>                 \u23d0 QuickStash Commands \u23d0                </bold></gold><br><gray>---------------------------------------------------</gray><br><br><gray>(Click to run)<br><click:run_command:'/qs enable'><hover:show_text:'<green>Enable QuickStash'><green>/qs enable</green></hover></click> <white>\u00bb Turns on the QuickStash feature</white><br><click:run_command:'/qs disable'><hover:show_text:'<red>Disable QuickStash'><red>/qs disable</red></hover></click> <white>\u00bb Turns off the QuickStash feature</white><br><click:run_command:'/qs sounds enable'><hover:show_text:'<green>Enable sound effects when stashing'><green>/qs sounds enable</green></hover></click> <white>\u00bb Turns on stash sounds</white><br><click:run_command:'/qs notifications enable'><hover:show_text:'<green>Enable stash notifications in chat'><green>/qs notifications enable</green></hover></click> <white>\u00bb Turns on stash notifications</white><br><click:run_command:'/qs notifications disable'><hover:show_text:'<red>Disable stash notifications in chat'><red>/qs notifications disable</red></hover></click> <white>\u00bb Turns off stash notifications</white><br><br><gray>---------------------------------------------------</gray><br><br>");
            return true;
        }
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("enable")) {
                if (this.ps.isQSEnabled(player)) {
                    player.sendRichMessage("<gold><bold>[<reset><yellow>QuickStash<gold><bold>]<reset> <gray>QuickStash is already enabled");
                } else {
                    this.ps.enableQS(player);
                    player.sendRichMessage("<gold><bold>[<reset><yellow>QuickStash<gold><bold>]<reset> <green>Enabled QuickStash");
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("disable")) {
                if (!this.ps.isQSEnabled(player)) {
                    player.sendRichMessage("<gold><bold>[<reset><yellow>QuickStash<gold><bold>]<reset> <gray>QuickStash is already disabled");
                } else {
                    this.ps.disableQS(player);
                    player.sendRichMessage("<gold><bold>[<reset><yellow>QuickStash<gold><bold>]<reset> <green>Disabled QuickStash");
                }
                return true;
            }
            player.sendRichMessage("<red>Missing arguments. Use /qs help");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("notifications")) {
            if (args[1].equalsIgnoreCase("enable")) {
                if (this.ps.areNotificationsEnabled(player)) {
                    player.sendRichMessage("<gold><bold>[<reset><yellow>QuickStash<gold><bold>]<reset> <gray>Notifications are already enabled");
                } else {
                    this.ps.enableNotifications(player);
                    player.sendRichMessage("<gold><bold>[<reset><yellow>QuickStash<gold><bold>]<reset> <green>Enabled notifications");
                }
                return true;
            }
            if (args[1].equalsIgnoreCase("disable")) {
                if (!this.ps.areNotificationsEnabled(player)) {
                    player.sendRichMessage("<gold><bold>[<reset><yellow>QuickStash<gold><bold>]<reset> <gray>Notifications are already disabled");
                } else {
                    this.ps.disableNotifications(player);
                    player.sendRichMessage("<gold><bold>[<reset><yellow>QuickStash<gold><bold>]<reset> <green>Disabled notifications");
                }
                return true;
            }
            player.sendRichMessage("<red>Usage: /qs notifications [enable | disable]");
        }
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] args) {
        List<String> options = List.of();
        if (args.length == 1) {
            options = List.of("help", "enable", "disable", "notifications");
            return options.stream().filter(option -> option.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equals("notifications")) {
            options = List.of("enable", "disable");
            return options.stream().filter(option -> option.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        return options;
    }
}

