/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.block;

import com.mojang.serialization.MapCodec;
import dev.apexstudios.apexcore.lib.block.SimpleHorizontalDirectionalBlock;
import dev.apexstudios.apexcore.lib.block.entity.InventoryBlockEntity;
import dev.apexstudios.fantasyfurniture.block.entity.FurnitureInventoryBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;

public class InventoryBlock
extends BaseEntityBlock {
    public static final MapCodec<InventoryBlock> CODEC = InventoryBlock.simpleCodec(InventoryBlock::new);
    public static final EnumProperty<Direction> FACING = SimpleHorizontalDirectionalBlock.FACING;

    public InventoryBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState blockState) {
        return new FurnitureInventoryBlockEntity(pos, blockState);
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        MenuProvider menuProvider = blockState.getMenuProvider(level, pos);
        if (menuProvider != null) {
            player.openMenu(menuProvider);
            if (level instanceof ServerLevel) {
                ServerLevel sLevel = (ServerLevel)level;
                PiglinAi.angerNearbyPiglins((ServerLevel)sLevel, (Player)player, (boolean)true);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(blockState, level, pos, player, hitResult);
    }

    protected void affectNeighborsAfterRemoval(BlockState blockState, ServerLevel level, BlockPos pos, boolean movedByPiston) {
        super.affectNeighborsAfterRemoval(blockState, level, pos, movedByPiston);
        Containers.updateNeighboursAfterDestroy((BlockState)blockState, (Level)level, (BlockPos)pos);
    }

    protected boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos, Direction facing) {
        ResourceHandler resourceHandler;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof InventoryBlockEntity) {
            InventoryBlockEntity blockEntity2 = (InventoryBlockEntity)blockEntity;
            resourceHandler = blockEntity2.getResourceHandler();
        } else {
            resourceHandler = null;
        }
        ResourceHandler itemHandler = resourceHandler;
        return itemHandler == null ? super.getAnalogOutputSignal(blockState, level, pos, facing) : ResourceHandlerUtil.getRedstoneSignalFromResourceHandler((ResourceHandler)itemHandler);
    }

    protected BlockState rotate(BlockState blockState, Rotation rot) {
        return (BlockState)blockState.setValue(FACING, (Comparable)rot.rotate((Direction)blockState.getValue(FACING)));
    }

    protected BlockState mirror(BlockState blockState, Mirror mirror) {
        return blockState.rotate(mirror.getRotation((Direction)blockState.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }
}

