/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.block;

import dev.apexstudios.apexcore.lib.block.entity.InventoryBlockEntity;
import dev.apexstudios.apexcore.lib.multiblock.MultiBlock;
import dev.apexstudios.apexcore.lib.multiblock.MultiBlockProperty;
import dev.apexstudios.fantasyfurniture.block.InventoryBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import org.jetbrains.annotations.Nullable;

public abstract class InventoryMultiBlock
extends InventoryBlock
implements MultiBlock {
    public InventoryMultiBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)this.getMultiBlockProperty(), (Comparable)Integer.valueOf(0)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{this.getMultiBlockProperty()});
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState placementBlockState = super.getStateForPlacement(context);
        if (placementBlockState == null || !MultiBlock.canPlace((BlockPlaceContext)context, (BlockState)placementBlockState)) {
            return null;
        }
        return placementBlockState;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, blockState, placer, stack);
        MultiBlock.setBlockStates((Level)level, (BlockPos)pos, (BlockState)blockState);
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState blockState) {
        super.destroy(level, pos, blockState);
        MultiBlock.destroyBlocks((LevelAccessor)level, (BlockPos)pos, (BlockState)blockState);
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState blockState) {
        super.spawnDestroyParticles(level, player, pos, blockState);
        MultiBlock.spawnDestroyParticles((LevelAccessor)level, (BlockPos)pos, (BlockState)blockState, (Entity)player);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState blockState) {
        return (Integer)blockState.getValue((Property)this.getMultiBlockProperty()) == 0 ? super.newBlockEntity(pos, blockState) : null;
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState blockState, ServerLevel level, BlockPos pos, boolean movedByPiston) {
        super.affectNeighborsAfterRemoval(blockState, level, pos, movedByPiston);
        MultiBlockProperty property = this.getMultiBlockProperty();
        int index = (Integer)blockState.getValue((Property)property);
        MultiBlock.forEachPos((BlockPos)pos, (BlockState)blockState, (otherPos, otherBlockState) -> {
            if (index != (Integer)otherBlockState.getValue((Property)property)) {
                level.updateNeighbourForOutputSignal(otherPos, otherBlockState.getBlock());
            }
        });
    }

    @Override
    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos, Direction facing) {
        int n;
        BlockEntity blockEntity = MultiBlock.getBlockEntity((BlockGetter)level, (BlockPos)pos, (BlockState)blockState);
        if (blockEntity instanceof InventoryBlockEntity) {
            InventoryBlockEntity inventory = (InventoryBlockEntity)blockEntity;
            n = ResourceHandlerUtil.getRedstoneSignalFromResourceHandler((ResourceHandler)inventory.getResourceHandler());
        } else {
            n = super.getAnalogOutputSignal(blockState, level, pos, facing);
        }
        return n;
    }

    protected boolean triggerEvent(BlockState blockState, Level level, BlockPos pos, int id, int param) {
        BlockEntity blockEntity = MultiBlock.getBlockEntity((BlockGetter)level, (BlockPos)pos, (BlockState)blockState);
        return blockEntity != null && blockEntity.triggerEvent(id, param);
    }

    @Nullable
    protected MenuProvider getMenuProvider(BlockState blockState, Level level, BlockPos pos) {
        MenuProvider provider;
        BlockEntity blockEntity = MultiBlock.getBlockEntity((BlockGetter)level, (BlockPos)pos, (BlockState)blockState);
        return blockEntity instanceof MenuProvider ? (provider = (MenuProvider)blockEntity) : null;
    }
}

