/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.block.property;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public enum CounterConnection implements StringRepresentable
{
    NONE("single"),
    CORNER_INNER("corner_inner"),
    CORNER_OUTER("corner_outer");

    public static final EnumProperty<CounterConnection> PROPERTY;
    private final String serializedName;

    private CounterConnection(String serializedName) {
        this.serializedName = serializedName;
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    public boolean isCorner() {
        return this == CORNER_INNER || this == CORNER_OUTER;
    }

    public String getModelSuffix() {
        if (this.isCorner()) {
            return "_corner";
        }
        return "_" + this.serializedName;
    }

    public static BlockState setConnection(BlockGetter level, BlockPos pos, BlockState blockState) {
        CounterConnection connection = CounterConnection.determine(level, pos, blockState);
        if (connection == CORNER_INNER) {
            Direction facing = (Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING);
            blockState = (BlockState)blockState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)facing.getCounterClockWise());
        }
        return (BlockState)blockState.setValue(PROPERTY, (Comparable)((Object)connection));
    }

    private static CounterConnection determine(BlockGetter level, BlockPos pos, BlockState blockState) {
        boolean hasLeft = CounterConnection.canConnect(level, pos, blockState, true);
        boolean hasRight = CounterConnection.canConnect(level, pos, blockState, false);
        if (hasLeft || hasRight) {
            return CounterConnection.asCorner(level, pos, blockState);
        }
        return NONE;
    }

    private static boolean canConnect(BlockGetter level, BlockPos pos, BlockState blockState, boolean left) {
        Direction facing = (Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING);
        Direction offset = left ? facing.getCounterClockWise() : facing.getClockWise();
        BlockPos otherPos = pos.relative(offset);
        BlockState otherBlockState = level.getBlockState(otherPos);
        if (!otherBlockState.is(blockState.getBlock())) {
            return false;
        }
        if (otherBlockState.getValue((Property)HorizontalDirectionalBlock.FACING) == facing) {
            return true;
        }
        return ((CounterConnection)((Object)otherBlockState.getValue(PROPERTY))).isCorner();
    }

    private static CounterConnection asCorner(BlockGetter level, BlockPos pos, BlockState blockState) {
        Direction facing = (Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING);
        BlockPos frontPos = pos.relative(facing);
        BlockState frontBlockState = level.getBlockState(frontPos);
        if (!frontBlockState.is(blockState.getBlock())) {
            return NONE;
        }
        Direction frontFacing = (Direction)frontBlockState.getValue((Property)HorizontalDirectionalBlock.FACING);
        if (frontFacing == facing.getCounterClockWise()) {
            return CORNER_INNER;
        }
        if (frontFacing.getCounterClockWise() == facing) {
            return CORNER_OUTER;
        }
        return NONE;
    }

    static {
        PROPERTY = EnumProperty.create((String)"connection", CounterConnection.class);
    }
}

