/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.ctm;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.apexstudios.apexcore.lib.data.ProviderType;
import dev.apexstudios.apexcore.lib.data.provider.context.ProviderOutputContext;
import dev.apexstudios.fantasyfurniture.FantasyFurniture;
import dev.apexstudios.fantasyfurniture.ctm.ExtendedBlockStateProvider;
import dev.apexstudios.fantasyfurniture.util.FurnitureUtil;
import dev.apexstudios.registree.api.Registree;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

final class ConTexProvider
extends ExtendedBlockStateProvider {
    public static final String ID = "contex";
    public static final ProviderType<ConTexProvider> PROVIDER_TYPE = ProviderType.register((ResourceLocation)FantasyFurniture.identifier("ctm/contex"), ConTexProvider::new);

    ConTexProvider() {
    }

    public void with(Registree registree) {
        FurnitureUtil.Names.block(registree, "carpet", carpet -> {
            Holder.Reference wool = registree.getOrThrow(Registries.BLOCK, "wool");
            ResourceLocation woolRegistryName = wool.key().location();
            ResourceLocation texture = woolRegistryName.withPrefix("block/");
            ResourceLocation ctmTexture = woolRegistryName.withPath(path -> "block/ctm/" + path + "_simple");
            BiConsumer<JsonObject, Boolean> additional = (root, isCarpet) -> {};
            if (ConTexProvider.isDyeable(registree)) {
                ResourceLocation tintTexture = woolRegistryName.withPath(path -> "block/" + path + "_tint");
                ResourceLocation tintCtmTexture = woolRegistryName.withPath(path -> "block/ctm/" + path + "_tint_simple");
                additional = (root, isCarpet) -> this.withTexture((JsonObject)root, tintTexture, tintCtmTexture, (boolean)isCarpet);
            }
            this.with((Block)wool.value(), texture, ctmTexture, false, additional);
            this.with((Block)carpet, texture, ctmTexture, true, additional);
        });
    }

    private void with(Block block, ResourceLocation texture, ResourceLocation ctmTexture, boolean isCarpet, BiConsumer<JsonObject, Boolean> additional) {
        this.with(block, root -> {
            this.withTexture((JsonObject)root, texture, ctmTexture, isCarpet);
            additional.accept((JsonObject)root, isCarpet);
        });
    }

    private void withTexture(JsonObject root, ResourceLocation texture, ResourceLocation ctmTexture, boolean isCarpet) {
        String metaKey = "contex_meta";
        JsonArray metaJson = root.has(metaKey) ? root.getAsJsonArray(metaKey) : new JsonArray();
        metaJson.add((JsonElement)Util.make((Object)new JsonObject(), conTexJson -> {
            conTexJson.addProperty("type", "contex:" + (isCarpet ? "carpet_full" : "full"));
            conTexJson.add("textures", (JsonElement)Util.make((Object)new JsonArray(), texturesJson -> texturesJson.add((JsonElement)Util.make((Object)new JsonObject(), textureJson -> {
                textureJson.addProperty("main_texture", texture.toString());
                textureJson.addProperty("ct_texture", ctmTexture.toString());
            }))));
        }));
        root.add(metaKey, (JsonElement)metaJson);
    }

    @Override
    protected JsonObject json(ProviderOutputContext context, Block block, Consumer<JsonObject> consumer) {
        JsonObject root = super.json(context, block, consumer);
        root.addProperty("neoforge:definition_type", "contex:definition");
        return root;
    }
}

