/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.ctm;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import dev.apexstudios.apexcore.lib.data.ProviderType;
import dev.apexstudios.apexcore.lib.data.pack.FeaturePackGenerator;
import dev.apexstudios.fantasyfurniture.ctm.CtmPacks;
import dev.apexstudios.registree.api.Registree;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;

public interface CtmPack {
    public String modId();

    default public String packId() {
        return "ctm-" + this.modId();
    }

    default public String displayName() {
        return this.packId();
    }

    default public String description() {
        return "Fantasy's Furniture " + this.displayName() + " CTM support";
    }

    default public boolean isEnabled() {
        return this.modId().equals("fantasyfurniture") || ModList.get().isLoaded(this.modId());
    }

    default public void provide(FeaturePackGenerator packGenerator) {
    }

    public static Builder builder(String modId) {
        return new Builder(modId);
    }

    public static final class Builder {
        private final String modId;
        @Nullable
        private String packId = null;
        @Nullable
        private String displayName = null;
        @Nullable
        private String description = null;
        private final Multimap<ProviderType<?>, Supplier<? extends BiConsumer<?, Registree>>> providers = MultimapBuilder.hashKeys().linkedHashSetValues().build();

        private Builder(String modId) {
            this.modId = modId;
        }

        public Builder packId(String packId) {
            this.packId = packId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public <TProvider> Builder providing(ProviderType<TProvider> providerType, Supplier<BiConsumer<TProvider, Registree>> consumer) {
            this.providers.put(providerType, consumer);
            return this;
        }

        public <TProvider> Builder providing(ProviderType<TProvider> providerType, BiConsumer<TProvider, Registree> consumer) {
            return this.providing(providerType, () -> consumer);
        }

        public CtmPack build() {
            return new CtmPack(){
                private final String modId;
                @Nullable
                private final String packId;
                @Nullable
                private final String displayName;
                @Nullable
                private final String description;
                private final Multimap<ProviderType<?>, Supplier<? extends BiConsumer<?, Registree>>> providers;
                {
                    this.modId = modId;
                    this.packId = packId;
                    this.displayName = displayName;
                    this.description = description;
                    this.providers = HashMultimap.create(providers);
                }

                @Override
                public String modId() {
                    return this.modId;
                }

                @Override
                public String packId() {
                    return Objects.requireNonNullElseGet(this.packId, () -> CtmPack.super.packId());
                }

                @Override
                public String displayName() {
                    return Objects.requireNonNullElseGet(this.displayName, () -> CtmPack.super.displayName());
                }

                @Override
                public String description() {
                    return Objects.requireNonNullElseGet(this.description, () -> CtmPack.super.description());
                }

                @Override
                public void provide(FeaturePackGenerator packGenerator) {
                    this.providers.keySet().forEach(providerType -> this.provide(packGenerator, (ProviderType)providerType));
                }

                private <TProvider> void provide(FeaturePackGenerator generator, ProviderType<TProvider> providerType) {
                    generator.providing(providerType, (context, provider) -> CtmPacks.REFERENCES.forEach(registree -> this.providers.get((Object)providerType).forEach(listener -> ((BiConsumer)listener.get()).accept(provider, registree))));
                }
            };
        }
    }
}

