/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.ctm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.apexstudios.apexcore.core.data.provider.BaseProvider;
import dev.apexstudios.apexcore.lib.data.provider.context.ProviderOutputContext;
import dev.apexstudios.registree.api.Registree;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;

public abstract class SimpleJsonProvider
implements BaseProvider {
    private static final Gson GSON = new GsonBuilder().create();
    private final Map<Block, Consumer<JsonObject>> map = Maps.newHashMap();

    protected abstract Path path(ProviderOutputContext var1, Block var2);

    protected JsonObject json(ProviderOutputContext context, Block block, Consumer<JsonObject> consumer) {
        JsonObject root = new JsonObject();
        consumer.accept(root);
        return root;
    }

    protected final void with(Block block, Consumer<JsonObject> consumer) {
        if (this.map.putIfAbsent(block, consumer) != null) {
            throw new IllegalStateException("Duplicate Model registration: " + String.valueOf(block));
        }
    }

    public CompletableFuture<?> generate(CachedOutput cache, ProviderOutputContext context) {
        ArrayList futures = Lists.newArrayList();
        this.map.forEach((block, consumer) -> futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)this.json(context, (Block)block, (Consumer<JsonObject>)consumer), (Path)this.path(context, (Block)block))));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public static ResourceLocation registryName(Block block) {
        return block.builtInRegistryHolder().key().location();
    }

    public static JsonObject existing(ResourceManager resourceManager, ResourceLocation path) {
        JsonObject jsonObject;
        block8: {
            BufferedReader reader = resourceManager.openAsReader(path);
            try {
                jsonObject = (JsonObject)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonObject.class);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            reader.close();
        }
        return jsonObject;
    }

    public static void copyInto(JsonObject from, JsonObject into) {
        from.keySet().forEach(key -> into.add(key, from.get(key).deepCopy()));
    }

    public static boolean isDyeable(Registree registree) {
        return registree.namespace().contains("royal");
    }
}

