/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.station;

import com.google.common.collect.Maps;
import dev.apexstudios.fantasyfurniture.station.FurnitureStationRecipe;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public final class FurnitureStationRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    @Nullable
    private String group = null;
    private final Ingredient planks;
    private final Optional<Ingredient> wool;
    private final Ingredient bindingAgent;
    private final ItemStack result;
    private final Map<String, Criterion<?>> criteria = Maps.newLinkedHashMap();

    private FurnitureStationRecipeBuilder(RecipeCategory category, Ingredient planks, @Nullable Ingredient wool, Ingredient bindingAgent, ItemStack result) {
        this.category = category;
        this.planks = planks;
        this.wool = Optional.ofNullable(wool);
        this.bindingAgent = bindingAgent;
        this.result = result;
    }

    public FurnitureStationRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public FurnitureStationRecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public Item getResult() {
        return this.result.getItem();
    }

    public void save(RecipeOutput output, ResourceKey<Recipe<?>> recipeKey) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe: " + String.valueOf(recipeKey.location()));
        }
        Advancement.Builder advancement = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked(recipeKey)).rewards(AdvancementRewards.Builder.recipe(recipeKey)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement).addCriterion(arg_0, arg_1));
        FurnitureStationRecipe recipe = new FurnitureStationRecipe(Objects.requireNonNullElse(this.group, ""), this.planks, this.wool, this.bindingAgent, this.result);
        output.accept(recipeKey, (Recipe)recipe, advancement.build(recipeKey.location().withPrefix("recipes/" + this.category.getFolderName() + "/")));
    }

    public static FurnitureStationRecipeBuilder builder(RecipeCategory category, Ingredient planks, @Nullable Ingredient wool, Ingredient bindingAgent, ItemStack result) {
        return new FurnitureStationRecipeBuilder(category, planks, wool, bindingAgent, result);
    }

    public static FurnitureStationRecipeBuilder builder(RecipeCategory category, Ingredient planks, @Nullable Ingredient wool, Ingredient bindingAgent, ItemLike result, int count) {
        return FurnitureStationRecipeBuilder.builder(category, planks, wool, bindingAgent, new ItemStack(result, count));
    }

    public static FurnitureStationRecipeBuilder builder(RecipeCategory category, Ingredient planks, @Nullable Ingredient wool, Ingredient bindingAgent, ItemLike result) {
        return FurnitureStationRecipeBuilder.builder(category, planks, wool, bindingAgent, new ItemStack(result));
    }
}

