/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.util;

import com.mojang.math.Quadrant;
import dev.apexstudios.apexcore.lib.data.ProviderTypes;
import dev.apexstudios.apexcore.lib.data.pack.PackGenerator;
import dev.apexstudios.apexcore.lib.data.provider.LanguageProvider;
import dev.apexstudios.apexcore.lib.data.provider.model.ModelProvider;
import dev.apexstudios.apexcore.lib.multiblock.MultiBlock;
import dev.apexstudios.fantasyfurniture.block.TableBlock;
import dev.apexstudios.fantasyfurniture.block.property.CounterConnection;
import dev.apexstudios.fantasyfurniture.block.property.ShelfConnection;
import dev.apexstudios.fantasyfurniture.block.property.SofaConnection;
import dev.apexstudios.fantasyfurniture.util.FurnitureDataUtil;
import dev.apexstudios.fantasyfurniture.util.FurnitureUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.stream.Collectors;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;

public interface FurnitureClientDataUtil {
    public static void registerDataGen(FurnitureDataUtil.DataGenContext context, PackGenerator<?> pack) {
        pack.providing(ProviderTypes.MODELS, ($, provider) -> FurnitureClientDataUtil.registerModels(context, provider)).providing(ProviderTypes.LANGUAGE, ($, provider) -> FurnitureClientDataUtil.registerLanguage(context, provider));
    }

    public static void registerModels(FurnitureDataUtil.DataGenContext context, ModelProvider provider) {
        BlockModelGenerators blockModels = provider.blockModels();
        provider.fromRegistree(context.registree());
        context.block(FurnitureDataUtil.DataType.MODEL, "planks", arg_0 -> ((BlockModelGenerators)blockModels).createTrivialCube(arg_0));
        context.block(FurnitureDataUtil.DataType.MODEL, "bricks", arg_0 -> ((BlockModelGenerators)blockModels).createTrivialCube(arg_0));
        context.block(FurnitureDataUtil.DataType.MODEL, "wool", arg_0 -> ((BlockModelGenerators)blockModels).createTrivialCube(arg_0));
        context.block(FurnitureDataUtil.DataType.MODEL, "carpet", block -> {
            Block wool = (Block)context.registree().getValueOrThrow(Registries.BLOCK, "wool");
            FurnitureClientDataUtil.createCarpetModel(block, wool, blockModels);
        });
        context.block(FurnitureDataUtil.DataType.MODEL, "dresser", block -> {
            FurnitureClientDataUtil.createLeftRightModel(block, blockModels);
            FurnitureClientDataUtil.registerSimpleBlockItemModel(block, blockModels);
        });
        context.block(FurnitureDataUtil.DataType.MODEL, "stool", arg_0 -> ((BlockModelGenerators)blockModels).createNonTemplateHorizontalBlock(arg_0));
        context.block(FurnitureDataUtil.DataType.MODEL, "cushion", arg_0 -> ((BlockModelGenerators)blockModels).createNonTemplateHorizontalBlock(arg_0));
        context.block(FurnitureDataUtil.DataType.MODEL, "lockbox", arg_0 -> ((BlockModelGenerators)blockModels).createNonTemplateHorizontalBlock(arg_0));
        context.block(FurnitureDataUtil.DataType.MODEL, "drawer", arg_0 -> ((BlockModelGenerators)blockModels).createNonTemplateHorizontalBlock(arg_0));
        context.block(FurnitureDataUtil.DataType.MODEL, "chair", block -> {
            FurnitureClientDataUtil.createBottomTopModel(block, blockModels);
            FurnitureClientDataUtil.registerSimpleBlockItemModel(block, blockModels);
        });
        context.block(FurnitureDataUtil.DataType.MODEL, "bookshelf", block -> {
            FurnitureClientDataUtil.createBookshelfModel(block, blockModels);
            FurnitureClientDataUtil.registerSimpleBlockItemModel(block, blockModels);
        });
        context.block(FurnitureDataUtil.DataType.MODEL, "bed_single", block -> {
            FurnitureClientDataUtil.createBedSingleModel(block, blockModels);
            FurnitureClientDataUtil.registerSimpleBlockItemModel(block, blockModels);
        });
        context.block(FurnitureDataUtil.DataType.MODEL, "bed_double", block -> {
            FurnitureClientDataUtil.createBedDoubleModel(block, blockModels);
            FurnitureClientDataUtil.registerSimpleBlockItemModel(block, blockModels);
        });
        context.block(FurnitureDataUtil.DataType.MODEL, "door_single", block -> {
            FurnitureClientDataUtil.createDoorModel(block, blockModels);
            blockModels.registerSimpleFlatItemModel(block.asItem());
        });
        context.block(FurnitureDataUtil.DataType.MODEL, "door_double", block -> {
            FurnitureClientDataUtil.createDoorModel(block, blockModels);
            blockModels.registerSimpleFlatItemModel(block.asItem());
        });
        context.block(FurnitureDataUtil.DataType.MODEL, "desk_left", block -> {
            FurnitureClientDataUtil.createLeftRightModel(block, blockModels);
            FurnitureClientDataUtil.registerSimpleBlockItemModel(block, blockModels);
        });
        context.block(FurnitureDataUtil.DataType.MODEL, "desk_right", block -> {
            FurnitureClientDataUtil.createLeftRightModel(block, blockModels);
            FurnitureClientDataUtil.registerSimpleBlockItemModel(block, blockModels);
        });
        context.block(FurnitureDataUtil.DataType.MODEL, "painting_wide", block -> {
            FurnitureClientDataUtil.createLeftRightModel(block, blockModels);
            FurnitureClientDataUtil.registerSimpleBlockItemModel(block, blockModels);
        });
        context.block(FurnitureDataUtil.DataType.MODEL, "painting_small", arg_0 -> ((BlockModelGenerators)blockModels).createNonTemplateHorizontalBlock(arg_0));
        context.block(FurnitureDataUtil.DataType.MODEL, "oven", arg_0 -> ((BlockModelGenerators)blockModels).createNonTemplateHorizontalBlock(arg_0));
        context.block(FurnitureDataUtil.DataType.MODEL, "chest", block -> {
            FurnitureClientDataUtil.createLeftRightModel(block, blockModels);
            FurnitureClientDataUtil.registerSimpleBlockItemModel(block, blockModels);
        });
        context.block(FurnitureDataUtil.DataType.MODEL, "floor_light", block -> {
            FurnitureClientDataUtil.createBottomTopModel(block, blockModels);
            FurnitureClientDataUtil.registerSimpleBlockItemModel(block, blockModels);
        });
        context.block(FurnitureDataUtil.DataType.MODEL, "chandelier", arg_0 -> ((BlockModelGenerators)blockModels).createNonTemplateModelBlock(arg_0));
        context.block(FurnitureDataUtil.DataType.MODEL, "shelf", block -> {
            FurnitureClientDataUtil.createShelfModel(block, blockModels);
            blockModels.registerSimpleItemModel(block, ModelLocationUtils.getModelLocation((Block)block, (String)ShelfConnection.NONE.getModelSuffix()));
        });
        context.block(FurnitureDataUtil.DataType.MODEL, "sofa", block -> {
            FurnitureClientDataUtil.createSofaModel(block, blockModels);
            blockModels.registerSimpleItemModel(block, ModelLocationUtils.getModelLocation((Block)block, (String)SofaConnection.NONE.getModelSuffix()));
        });
        context.block(FurnitureDataUtil.DataType.MODEL, "counter", block -> {
            FurnitureClientDataUtil.createCounterModel(block, blockModels);
            blockModels.registerSimpleItemModel(block, ModelLocationUtils.getModelLocation((Block)block, (String)CounterConnection.NONE.getModelSuffix()));
        });
        context.block(FurnitureDataUtil.DataType.MODEL, "wall_light", block -> FurnitureClientDataUtil.createWallLightModel(block, blockModels));
        context.block(FurnitureDataUtil.DataType.MODEL, "bench", block -> {
            FurnitureClientDataUtil.createLeftRightModel(block, blockModels);
            FurnitureClientDataUtil.registerSimpleBlockItemModel(block, blockModels);
        });
        context.block(FurnitureDataUtil.DataType.MODEL, "wardrobe", block -> {
            FurnitureClientDataUtil.createWardrobeModel(block, blockModels);
            FurnitureClientDataUtil.registerSimpleBlockItemModel(block, blockModels);
        });
        context.block(FurnitureDataUtil.DataType.MODEL, "table", block -> FurnitureClientDataUtil.createTableModel(block, blockModels));
        context.block(FurnitureDataUtil.DataType.MODEL, "hanging_sign", block -> {
            Block hangingSign = (Block)context.registree().getValueOrThrow(Registries.BLOCK, "wall_hanging_sign");
            blockModels.createHangingSign(context.family().getBaseBlock(), block, hangingSign);
        });
        blockModels.familyWithExistingFullBlock(context.family().getBaseBlock()).generateFor(context.family());
    }

    public static void createWardrobeModel(Block block, BlockModelGenerators blockModels) {
        blockModels.blockStateOutput.accept(FurnitureClientDataUtil.multiBlockVariantGenerator(block, (Int2ObjectFunction<String>)((Int2ObjectFunction)index -> switch (index) {
            case 0 -> "_bottom_left";
            case 1 -> "_bottom_right";
            case 2 -> "_middle_left";
            case 3 -> "_middle_right";
            case 4 -> "_top_left";
            default -> "_top_right";
        })).with(BlockModelGenerators.ROTATION_HORIZONTAL_FACING));
    }

    public static void createWallLightModel(Block block, BlockModelGenerators blockModels) {
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block, (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)block))).with(BlockModelGenerators.ROTATION_HORIZONTAL_FACING));
    }

    public static void createCounterModel(Block block, BlockModelGenerators blockModels) {
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with(PropertyDispatch.initial(CounterConnection.PROPERTY).generate(connection -> BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)block, (String)connection.getModelSuffix())))).with(BlockModelGenerators.ROTATION_HORIZONTAL_FACING));
    }

    public static void createSofaModel(Block block, BlockModelGenerators blockModels) {
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with(PropertyDispatch.initial(SofaConnection.PROPERTY).generate(connection -> BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)block, (String)connection.getModelSuffix())))).with(BlockModelGenerators.ROTATION_HORIZONTAL_FACING));
    }

    public static void createShelfModel(Block block, BlockModelGenerators blockModels) {
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with(PropertyDispatch.initial(ShelfConnection.PROPERTY).generate(connection -> BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)block, (String)connection.getModelSuffix())))).with(BlockModelGenerators.ROTATION_HORIZONTAL_FACING));
    }

    public static void createBedDoubleModel(Block block, BlockModelGenerators blockModels) {
        blockModels.blockStateOutput.accept(FurnitureClientDataUtil.multiBlockVariantGenerator(block, (Int2ObjectFunction<String>)((Int2ObjectFunction)index -> switch (index) {
            case 1 -> "_top_left";
            case 2 -> "_top_right";
            case 3 -> "_bottom_right";
            default -> "_bottom_left";
        })).with(BlockModelGenerators.ROTATION_HORIZONTAL_FACING_ALT));
    }

    public static void createBedSingleModel(Block block, BlockModelGenerators blockModels) {
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with((PropertyDispatch)PropertyDispatch.initial((Property)BedBlock.PART).select((Comparable)BedPart.HEAD, (Object)BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)block, (String)"_top"))).select((Comparable)BedPart.FOOT, (Object)BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)block, (String)"_bottom")))).with(BlockModelGenerators.ROTATION_HORIZONTAL_FACING_ALT));
    }

    public static void createBookshelfModel(Block block, BlockModelGenerators blockModels) {
        blockModels.blockStateOutput.accept(FurnitureClientDataUtil.multiBlockVariantGenerator(block, (Int2ObjectFunction<String>)((Int2ObjectFunction)index -> switch (index) {
            case 0 -> "_bottom_left";
            case 1 -> "_bottom_right";
            case 2 -> "_top_left";
            default -> "_top_right";
        })).with(BlockModelGenerators.ROTATION_HORIZONTAL_FACING));
    }

    public static void createTableModel(Block block, BlockModelGenerators blockModels) {
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with(PropertyDispatch.initial((Property)HorizontalDirectionalBlock.FACING, (Property)TableBlock.NORTH, (Property)TableBlock.EAST, (Property)TableBlock.SOUTH, (Property)TableBlock.WEST).generate((facing, north, east, south, west) -> {
            Rotation rotation;
            EnumSet<Direction> connections = EnumSet.noneOf(Direction.class);
            Direction facingForConnection = TableBlock.getFacingForConnection(facing);
            switch (facingForConnection) {
                case EAST: {
                    Rotation rotation2 = Rotation.CLOCKWISE_90;
                    break;
                }
                case SOUTH: {
                    Rotation rotation2 = Rotation.CLOCKWISE_180;
                    break;
                }
                case WEST: {
                    Rotation rotation2 = Rotation.COUNTERCLOCKWISE_90;
                    break;
                }
                default: {
                    Rotation rotation2 = rotation = Rotation.NONE;
                }
            }
            if (north.booleanValue()) {
                connections.add(Direction.NORTH);
            }
            if (east.booleanValue()) {
                connections.add(Direction.EAST);
            }
            if (south.booleanValue()) {
                connections.add(Direction.SOUTH);
            }
            if (west.booleanValue()) {
                connections.add(Direction.WEST);
            }
            String connectionId = connections.stream().map(arg_0 -> ((Rotation)rotation).rotate(arg_0)).sorted(Comparator.comparingInt(connection -> switch (connection) {
                case Direction.NORTH -> 0;
                case Direction.EAST -> 1;
                case Direction.SOUTH -> 2;
                case Direction.WEST -> 3;
                default -> -1;
            })).map(Direction::getSerializedName).map(String::toLowerCase).map(str -> str.substring(0, 1)).collect(Collectors.joining());
            Object suffix = connectionId.isBlank() ? "" : "_" + connectionId;
            return BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)block, (String)suffix)).with(variant -> variant.withYRot(switch (facing) {
                case Direction.EAST -> Quadrant.R90;
                case Direction.SOUTH -> Quadrant.R180;
                case Direction.WEST -> Quadrant.R270;
                default -> Quadrant.R0;
            }));
        })));
    }

    public static void createLeftRightModel(Block block, BlockModelGenerators blockModels) {
        blockModels.blockStateOutput.accept(FurnitureClientDataUtil.multiBlockVariantGenerator(block, (Int2ObjectFunction<String>)((Int2ObjectFunction)index -> switch (index) {
            case 0 -> "_left";
            default -> "_right";
        })).with(BlockModelGenerators.ROTATION_HORIZONTAL_FACING));
    }

    public static void createBottomTopModel(Block block, BlockModelGenerators blockModels) {
        blockModels.blockStateOutput.accept(FurnitureClientDataUtil.multiBlockVariantGenerator(block, (Int2ObjectFunction<String>)((Int2ObjectFunction)index -> switch (index) {
            case 0 -> "_bottom";
            default -> "_top";
        })).with(BlockModelGenerators.ROTATION_HORIZONTAL_FACING));
    }

    public static void createCarpetModel(Block block, Block wool, BlockModelGenerators blockModels) {
        MultiVariant variant = BlockModelGenerators.plainVariant((ResourceLocation)TexturedModel.CARPET.get(wool).create(block, blockModels.modelOutput));
        blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (MultiVariant)variant));
    }

    public static void createDoorModel(Block block, BlockModelGenerators blockModels) {
        MultiVariant bottomClosed = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)block, (String)"_bottom_closed"));
        MultiVariant bottomOpen = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)block, (String)"_bottom_open"));
        MultiVariant topClosed = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)block, (String)"_top_closed"));
        MultiVariant topOpen = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)block, (String)"_top_open"));
        blockModels.blockStateOutput.accept(BlockModelGenerators.createDoor((Block)block, (MultiVariant)bottomClosed, (MultiVariant)bottomOpen, (MultiVariant)bottomOpen, (MultiVariant)bottomClosed, (MultiVariant)topClosed, (MultiVariant)topOpen, (MultiVariant)topOpen, (MultiVariant)topClosed));
    }

    public static void registerSimpleBlockItemModel(Block block, BlockModelGenerators blockModels) {
        blockModels.registerSimpleItemModel(block, ModelLocationUtils.getModelLocation((Item)block.asItem()));
    }

    public static MultiVariantGenerator multiBlockVariantGenerator(Block block, Int2ObjectFunction<String> suffixLookup) {
        return MultiVariantGenerator.dispatch((Block)block).with(FurnitureClientDataUtil.multiBlockPropertyDispatch(block, suffixLookup));
    }

    public static PropertyDispatch<MultiVariant> multiBlockPropertyDispatch(Block block, Int2ObjectFunction<String> suffixLookup) {
        return PropertyDispatch.initial((Property)((MultiBlock)block).getMultiBlockProperty()).generate(index -> BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)block, (String)((String)suffixLookup.apply(index)))));
    }

    public static void registerLanguage(FurnitureDataUtil.DataGenContext context, LanguageProvider provider) {
        FurnitureUtil.Names.creativeModeTab(context.registree(), key -> provider.addCreativeModeTab(key, "Fantasy's Furniture - " + context.englishName()));
        FurnitureClientDataUtil.registerLanguage(context, "planks", "Planks", provider);
        FurnitureClientDataUtil.registerLanguage(context, "bricks", "Bricks", provider);
        FurnitureClientDataUtil.registerLanguage(context, "wool", "Wool", provider);
        FurnitureClientDataUtil.registerLanguage(context, "carpet", "Carpet", provider);
        FurnitureClientDataUtil.registerLanguage(context, "dresser", "Dresser", provider);
        FurnitureClientDataUtil.registerLanguage(context, "stool", "Stool", provider);
        FurnitureClientDataUtil.registerLanguage(context, "cushion", "Cushion", provider);
        FurnitureClientDataUtil.registerLanguage(context, "lockbox", "Lockbox", provider);
        FurnitureClientDataUtil.registerLanguage(context, "drawer", "Drawer", provider);
        FurnitureClientDataUtil.registerLanguage(context, "chair", "Chair", provider);
        FurnitureClientDataUtil.registerLanguage(context, "bookshelf", "Bookshelf", provider);
        FurnitureClientDataUtil.registerLanguage(context, "bed_single", "Bed Single", provider);
        FurnitureClientDataUtil.registerLanguage(context, "bed_double", "Bed Double", provider);
        FurnitureClientDataUtil.registerLanguage(context, "door_single", "Door Single", provider);
        FurnitureClientDataUtil.registerLanguage(context, "door_double", "Door Double", provider);
        FurnitureClientDataUtil.registerLanguage(context, "desk_left", "Desk Left", provider);
        FurnitureClientDataUtil.registerLanguage(context, "desk_right", "Desk Right", provider);
        FurnitureClientDataUtil.registerLanguage(context, "painting_wide", "Painting Wide", provider);
        FurnitureClientDataUtil.registerLanguage(context, "painting_small", "Painting Small", provider);
        FurnitureClientDataUtil.registerLanguage(context, "oven", "Oven", provider);
        FurnitureClientDataUtil.registerLanguage(context, "chest", "Chest", provider);
        FurnitureClientDataUtil.registerLanguage(context, "floor_light", "Floor Light", provider);
        FurnitureClientDataUtil.registerLanguage(context, "chandelier", "Chandelier", provider);
        FurnitureClientDataUtil.registerLanguage(context, "shelf", "Shelf", provider);
        FurnitureClientDataUtil.registerLanguage(context, "sofa", "Sofa", provider);
        FurnitureClientDataUtil.registerLanguage(context, "counter", "Counter", provider);
        FurnitureClientDataUtil.registerLanguage(context, "wall_light", "Wall Light", provider);
        FurnitureClientDataUtil.registerLanguage(context, "bench", "Bench", provider);
        FurnitureClientDataUtil.registerLanguage(context, "wardrobe", "Wardrobe", provider);
        FurnitureClientDataUtil.registerLanguage(context, "table", "Table", provider);
        FurnitureClientDataUtil.registerLanguage(context, "stairs", "Stairs", provider);
        FurnitureClientDataUtil.registerLanguage(context, "slab", "Slab", provider);
        FurnitureClientDataUtil.registerLanguage(context, "fence", "Fence", provider);
        FurnitureClientDataUtil.registerLanguage(context, "fence_gate", "Fence Gate", provider);
        FurnitureClientDataUtil.registerLanguage(context, "trapdoor", "Trapdoor", provider);
        FurnitureClientDataUtil.registerLanguage(context, "pressure_plate", "Pressure Plate", provider);
        FurnitureClientDataUtil.registerLanguage(context, "button", "Button", provider);
        FurnitureClientDataUtil.registerLanguage(context, "hanging_sign", "Hanging Sign", provider);
        FurnitureClientDataUtil.registerLanguage(context, "wall_hanging_sign", "Wall Hanging Sign", provider);
        FurnitureClientDataUtil.registerLanguage(context, "sign", "Sign", provider);
        FurnitureClientDataUtil.registerLanguage(context, "wall_sign", "Wall Sign", provider);
    }

    private static void registerLanguage(FurnitureDataUtil.DataGenContext context, String name, String englishName, LanguageProvider provider) {
        context.block(FurnitureDataUtil.DataType.LANGUAGE, name, block -> provider.add(block, context.englishName() + " " + englishName));
    }
}

