/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.pillars.game;

import com.yourname.pillars.PillarsPlugin;
import com.yourname.pillars.game.ItemDropScheduler;
import com.yourname.pillars.game.LocationManager;
import com.yourname.pillars.game.PillarGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;

public class GameManager {
    private final PillarsPlugin plugin;
    private final Set<UUID> alivePlayers = new HashSet<UUID>();
    private final PillarGenerator generator;
    private final ItemDropScheduler dropScheduler;
    private final LocationManager locationManager;
    private int platformY = 0;
    private int fallMonitorTaskId = -1;

    public GameManager(PillarsPlugin plugin) {
        this.plugin = plugin;
        this.generator = new PillarGenerator(plugin);
        this.dropScheduler = new ItemDropScheduler(plugin);
        this.locationManager = new LocationManager();
    }

    public void startGame() {
        Location base = this.locationManager.getNextLocation();
        List<Location> pillars = this.generator.generatePillars(base);
        ArrayList players = new ArrayList(Bukkit.getOnlinePlayers());
        this.alivePlayers.clear();
        this.platformY = base.getBlockY() + this.plugin.getConfig().getInt("pillar.height") + 3;
        for (int i = 0; i < players.size() && i < 8; ++i) {
            Player p = (Player)players.get(i);
            p.teleport(pillars.get(i));
            p.getInventory().clear();
            this.alivePlayers.add(p.getUniqueId());
        }
        this.generator.spawnCenterLoot(pillars.get(4));
        this.dropScheduler.startDrops(this.alivePlayers);
        this.startFallMonitor();
        Bukkit.broadcastMessage((String)"\u00a7ePillars game has begun!");
    }

    public void handleDeath(Player player) {
        this.alivePlayers.remove(player.getUniqueId());
        this.teleportToSpectatorLobby(player);
        if (this.alivePlayers.size() == 1) {
            UUID winnerId = this.alivePlayers.iterator().next();
            Player winner = Bukkit.getPlayer((UUID)winnerId);
            this.showWinSequence(winner);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this::startGame, 200L);
        }
    }

    public void showWinSequence(Player winner) {
        Location loc = winner.getLocation();
        World world = loc.getWorld();
        winner.sendTitle("\u00a76Victory!", "\u00a7eYou are the last one standing!", 10, 60, 10);
        Bukkit.broadcastMessage((String)("\u00a76\u2694 " + winner.getName() + " has won the Pillars match! \u2694"));
        for (int i = 0; i < 5; ++i) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                Firework fw = (Firework)world.spawn(loc, Firework.class);
                FireworkMeta meta = fw.getFireworkMeta();
                meta.addEffect(FireworkEffect.builder().withColor(Color.ORANGE).withFade(Color.YELLOW).with(FireworkEffect.Type.STAR).trail(true).flicker(true).build());
                meta.setPower(2);
                fw.setFireworkMeta(meta);
            }, (long)i * 20L);
        }
        world.strikeLightningEffect(loc);
    }

    public void teleportToSpectatorLobby(Player player) {
        int z;
        World world = (World)Bukkit.getWorlds().get(0);
        Location base = new Location(world, 0.0, 250.0, 0.0);
        for (int x = -5; x <= 5; ++x) {
            for (z = -5; z <= 5; ++z) {
                world.getBlockAt(base.clone().add((double)x, 0.0, (double)z)).setType(Material.BARRIER);
            }
        }
        for (int y = 1; y <= 5; ++y) {
            for (int x = -5; x <= 5; ++x) {
                world.getBlockAt(base.clone().add((double)x, (double)y, -5.0)).setType(Material.BARRIER);
                world.getBlockAt(base.clone().add((double)x, (double)y, 5.0)).setType(Material.BARRIER);
            }
            for (z = -5; z <= 5; ++z) {
                world.getBlockAt(base.clone().add(-5.0, (double)y, (double)z)).setType(Material.BARRIER);
                world.getBlockAt(base.clone().add(5.0, (double)y, (double)z)).setType(Material.BARRIER);
            }
        }
        player.teleport(base.clone().add(0.0, 1.0, 0.0));
        player.sendMessage("\u00a77You are now spectating from the sky lobby.");
    }

    public void startFallMonitor() {
        this.stopFallMonitor();
        this.fallMonitorTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
            for (UUID id : new HashSet<UUID>(this.alivePlayers)) {
                Player p = Bukkit.getPlayer((UUID)id);
                if (p == null || !p.isOnline() || !(p.getLocation().getY() < (double)(this.platformY - 30))) continue;
                p.setHealth(0.0);
                p.sendMessage("\u00a7cYou fell too far and were eliminated!");
            }
        }, 0L, 20L);
    }

    public void stopFallMonitor() {
        if (this.fallMonitorTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.fallMonitorTaskId);
            this.fallMonitorTaskId = -1;
        }
    }

    public void cleanup() {
        this.dropScheduler.stopDrops();
        this.stopFallMonitor();
    }
}

