/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.pillars.game;

import com.yourname.pillars.PillarsPlugin;
import com.yourname.pillars.utils.ItemUtils;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ItemDropScheduler {
    private final PillarsPlugin plugin;
    private int taskId = -1;

    public ItemDropScheduler(PillarsPlugin plugin) {
        this.plugin = plugin;
    }

    public void startDrops(Set<UUID> players) {
        this.stopDrops();
        this.taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
            for (UUID id : players) {
                Player p = Bukkit.getPlayer((UUID)id);
                if (p == null || !p.isOnline()) continue;
                ItemStack item = ItemUtils.getRandomItem(this.plugin, p);
                p.getInventory().addItem(new ItemStack[]{item});
                p.sendMessage("\u00a7bYou received: \u00a7f" + String.valueOf(item.getType()));
            }
        }, 0L, 200L);
    }

    public void stopDrops() {
        if (this.taskId != -1) {
            Bukkit.getScheduler().cancelTask(this.taskId);
            this.taskId = -1;
        }
    }
}

