/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.pillars.game;

import com.yourname.pillars.PillarsPlugin;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class PillarGenerator {
    private final PillarsPlugin plugin;

    public PillarGenerator(PillarsPlugin plugin) {
        this.plugin = plugin;
    }

    public List<Location> generatePillars(Location base) {
        ArrayList<Location> locations = new ArrayList<Location>();
        int spacing = this.plugin.getConfig().getInt("pillar.spacing");
        int height = this.plugin.getConfig().getInt("pillar.height");
        Material blockType = Material.valueOf((String)this.plugin.getConfig().getString("pillar.block"));
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                Location loc = base.clone().add((double)(x * spacing), 0.0, (double)(z * spacing));
                this.buildPillar(loc, height, blockType);
                locations.add(loc.clone().add(0.0, (double)(height + 3), 0.0));
            }
        }
        return locations;
    }

    private void buildPillar(Location loc, int height, Material blockType) {
        World world = loc.getWorld();
        for (int y = 0; y < height; ++y) {
            Block block = world.getBlockAt(loc.getBlockX(), loc.getBlockY() + y, loc.getBlockZ());
            block.setType(blockType);
        }
        int topY = loc.getBlockY() + height;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                Block platform = world.getBlockAt(loc.getBlockX() + dx, topY, loc.getBlockZ() + dz);
                platform.setType(blockType);
            }
        }
        world.getBlockAt(loc.getBlockX(), topY + 1, loc.getBlockZ()).setType(blockType);
        world.getBlockAt(loc.getBlockX(), topY + 2, loc.getBlockZ()).setType(blockType);
    }

    public void spawnCenterLoot(Location loc) {
        loc.getBlock().setType(Material.CHEST);
        Chest chest = (Chest)loc.getBlock().getState();
        Inventory inv = chest.getInventory();
        for (String itemStr : this.plugin.getConfig().getStringList("center_loot")) {
            Material mat = Material.valueOf((String)itemStr);
            inv.addItem(new ItemStack[]{new ItemStack(mat)});
        }
    }
}

