/*
 * Decompiled with CFR 0.152.
 */
package com.modencore.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeHooks;

public abstract class AbstractBushBlock
extends VegetationBlock
implements BonemealableBlock {
    public static final int MAX_AGE = 4;
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)4);
    Supplier<Item> dropItem;
    Supplier<Item> cloneItem;

    public AbstractBushBlock(BlockBehaviour.Properties properties, Supplier<Item> dropItem, Supplier<Item> cloneItem) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
        this.dropItem = dropItem;
        this.cloneItem = cloneItem;
    }

    protected ItemStack getCloneItemStack(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIncludeData) {
        return new ItemStack((ItemLike)this.cloneItem.get());
    }

    protected boolean isRandomlyTicking(BlockState pState) {
        return (Integer)pState.getValue((Property)AGE) < 4;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{AGE});
    }

    protected void randomTick(BlockState blockState, ServerLevel level, BlockPos blockPos, RandomSource pRandom) {
        int i = (Integer)blockState.getValue((Property)AGE);
        if (i < 4 && level.getRawBrightness(blockPos.above(), 0) >= 9 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)blockPos, (BlockState)blockState, (pRandom.nextInt(5) == 0 ? 1 : 0) != 0)) {
            BlockState blockstate = (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            level.setBlock(blockPos, blockstate, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((BlockState)blockstate));
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)blockPos, (BlockState)blockState);
        }
    }

    protected InteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand p_336388_, BlockHitResult p_334205_) {
        int i = (Integer)blockState.getValue((Property)AGE);
        boolean flag = i == 4;
        return !flag && itemStack.is(Items.BONE_MEAL) ? InteractionResult.PASS : super.useItemOn(itemStack, blockState, level, blockPos, player, p_336388_, p_334205_);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level level, BlockPos blockPos, Player player, BlockHitResult result) {
        boolean flag;
        int i = (Integer)pState.getValue((Property)AGE);
        boolean bl = flag = i == 4;
        if (i > 3) {
            int j = 1 + level.random.nextInt(1);
            AbstractBushBlock.popResource((Level)level, (BlockPos)blockPos, (ItemStack)new ItemStack((ItemLike)this.dropItem.get(), j + (flag ? 1 : 0)));
            level.playSound(null, blockPos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            BlockState blockstate = (BlockState)pState.setValue((Property)AGE, (Comparable)Integer.valueOf(2));
            level.setBlock(blockPos, blockstate, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)player, (BlockState)blockstate));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean isValidBonemealTarget(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return true;
    }

    public boolean isBonemealSuccess(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void performBonemeal(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        int i = Math.min(4, (Integer)pState.getValue((Property)AGE) + 1);
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }
}

