/*
 * Decompiled with CFR 0.152.
 */
package com.sabrepotato.citnbt.client;

import com.sabrepotato.citnbt.client.TextureModelHandler;
import com.sabrepotato.citnbt.resources.ItemRule;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class DynamicBakedModel
implements IBakedModel {
    private final IBakedModel defaultModel;
    private final List<ItemRule> rules;

    public DynamicBakedModel(IBakedModel defaultModel, List<ItemRule> rules) {
        this.defaultModel = defaultModel;
        this.rules = rules;
    }

    public List<BakedQuad> getQuads(@Nullable IBlockState iBlockState, @Nullable EnumFacing enumFacing, long rand) {
        return this.defaultModel.getQuads(iBlockState, enumFacing, rand);
    }

    public boolean isAmbientOcclusion() {
        return this.defaultModel.isAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.defaultModel.isGui3d();
    }

    public boolean isBuiltInRenderer() {
        return this.defaultModel.isBuiltInRenderer();
    }

    public TextureAtlasSprite getParticleTexture() {
        return this.defaultModel.getParticleTexture();
    }

    public ItemCameraTransforms getItemCameraTransforms() {
        return this.defaultModel.getItemCameraTransforms();
    }

    public ItemOverrideList getOverrides() {
        return new ItemOverrideList(Collections.emptyList()){

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                for (ItemRule rule : DynamicBakedModel.this.rules) {
                    IBakedModel result;
                    IBakedModel candidate;
                    if (!rule.matches(stack, entity) || (candidate = TextureModelHandler.BAKED_MODELS.get(rule)) == null || (result = DynamicBakedModel.this.defaultModel.getOverrides().handleItemState(candidate, stack, world, entity)) != candidate) continue;
                    return candidate;
                }
                return DynamicBakedModel.this.defaultModel.getOverrides().handleItemState(DynamicBakedModel.this.defaultModel, stack, world, entity);
            }
        };
    }

    public boolean isAmbientOcclusion(IBlockState state) {
        return this.defaultModel.isAmbientOcclusion(state);
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return this.defaultModel.handlePerspective(cameraTransformType);
    }
}

