/*
 * Decompiled with CFR 0.152.
 */
package com.sabrepotato.citnbt.config;

import com.sabrepotato.citnbt.CITNBT;
import com.sabrepotato.citnbt.config.NBTHolder;
import com.sabrepotato.citnbt.resources.ItemRule;
import com.sabrepotato.citnbt.resources.conditions.ItemstackCondition;
import com.sabrepotato.citnbt.resources.conditions.NBTCondition;
import com.sabrepotato.citnbt.resources.conditions.Range;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;

public class FileNBTLoader {
    public static List<NBTHolder> ITEM_RULES = new ArrayList<NBTHolder>();

    public static void loadFiles() {
        FileNBTLoader.loadFiles("resources");
    }

    private static void loadFiles(String directory) {
        File resourceDir = new File(Minecraft.getMinecraft().gameDir, directory);
        if (resourceDir.exists() && resourceDir.isDirectory()) {
            Stream<Path> stream2;
            Path resource = resourceDir.toPath();
            Path citResource = resource.resolve("optifine/cit");
            try {
                stream2 = Files.walk(citResource, new FileVisitOption[0]);
                try {
                    stream2.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".properties")).forEach(FileNBTLoader::loadProperty);
                }
                finally {
                    if (stream2 != null) {
                        stream2.close();
                    }
                }
            }
            catch (Exception stream2) {
                // empty catch block
            }
            try {
                stream2 = Files.walk(resource, new FileVisitOption[0]);
                try {
                    stream2.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                        if (path.toString().endsWith(".cit.properties")) {
                            FileNBTLoader.loadProperty(path);
                        }
                        CITNBT.LOGGER.info("Loaded file {}", (Object)path.toString());
                    });
                }
                finally {
                    if (stream2 != null) {
                        stream2.close();
                    }
                }
            }
            catch (Exception e) {
                CITNBT.LOGGER.error("Unable to read directory {}", (Object)resource);
            }
        }
        Collections.sort(ITEM_RULES);
    }

    private static void loadProperty(Path path) {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            Properties properties = new Properties();
            properties.load(inputStream);
            String method = properties.getProperty("method", "average");
            String cap = properties.getProperty("cap");
            String fade = properties.getProperty("fade", "0.5");
            String useGlint = properties.getProperty("useGlint", "true");
            String type = properties.getProperty("type", "item");
            String items = properties.getProperty("items");
            List<String> itemList = Arrays.asList(properties.getProperty("items").split(" "));
            String texture = properties.getProperty("texture");
            HashMap<String, String> textures = new HashMap<String, String>();
            String model = properties.getProperty("model");
            String damage = properties.getProperty("damage");
            String damageMask = properties.getProperty("damageMask");
            String stackSize = properties.getProperty("stackSize");
            String enchantments = properties.getProperty("enchantments", properties.getProperty("enchantmentIDs"));
            String enchantmentLevels = properties.getProperty("enchantmentLevels");
            String hand = properties.getProperty("hand", "any");
            String nbt = properties.getProperty("nbt");
            String weight = properties.getProperty("weight", "0");
            int fileWeight = FileNBTLoader.tryParseInt(weight, 0);
            ItemstackCondition itemstack = FileNBTLoader.setItemStackCondition(damage, stackSize, hand, enchantments, enchantmentLevels, damageMask);
            ArrayList<NBTCondition> rules = new ArrayList<NBTCondition>();
            for (String key : properties.stringPropertyNames()) {
                if (key.startsWith("nbt.")) {
                    String nbtPath = key.substring(4);
                    String val = properties.getProperty(key);
                    rules.add(FileNBTLoader.setNbtCondition(nbtPath, val));
                    continue;
                }
                if (key.startsWith("nbt")) {
                    rules.add(FileNBTLoader.setNbtCondition("", nbt));
                    continue;
                }
                if (!key.startsWith("texture.")) continue;
                textures.put(key.substring(8), properties.getProperty(key));
            }
            if (type.equals("item")) {
                ResourceLocation modelLoc;
                if (items.isEmpty() || texture == null && textures.isEmpty() && model == null) {
                    return;
                }
                List<ModelResourceLocation> itemLocs = itemList.stream().map(item -> new ModelResourceLocation(item, "inventory")).collect(Collectors.toList());
                ResourceLocation resourceLocation = modelLoc = model != null ? new ResourceLocation(model) : null;
                if (textures.isEmpty()) {
                    ResourceLocation textureLoc = texture != null ? new ResourceLocation(texture) : null;
                    itemLocs.forEach(itemLoc -> {
                        ItemRule rule = new ItemRule((List<NBTCondition>)rules, (ModelResourceLocation)itemLoc, itemstack);
                        ITEM_RULES.add(new NBTHolder(textureLoc, modelLoc, rule, path.getFileName().toString(), fileWeight));
                    });
                } else {
                    Map<String, ResourceLocation> map = textures.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue() != null ? new ResourceLocation((String)entry.getValue()) : null));
                    itemLocs.forEach(itemLoc -> {
                        ItemRule rule = new ItemRule((List<NBTCondition>)rules, (ModelResourceLocation)itemLoc, itemstack);
                        ITEM_RULES.add(new NBTHolder(map, modelLoc, rule, path.getFileName().toString(), fileWeight));
                    });
                }
            } else if (type.equals("enchantment")) {
                String blend = properties.getProperty("blend", "add");
                String speed = properties.getProperty("speed", "1");
                String rotation = properties.getProperty("rotation");
                String layer = properties.getProperty("layer", "0");
                String string = properties.getProperty("duration", "0");
            } else if (type.equals("armor")) {
            } else if (type.equals("elytra")) {
                // empty if block
            }
        }
        catch (IOException e) {
            CITNBT.LOGGER.error("Unable to read file {}", (Object)path);
        }
    }

    private static ItemstackCondition setItemStackCondition(String damage, String stackSize, String hand, String enchantments, String enchantmentLevels, String damageMask) {
        ItemstackCondition stack = new ItemstackCondition();
        if (damage != null) {
            stack.addDamageRule(damage);
        }
        if (stackSize != null) {
            stack.addStackRule(stackSize);
        }
        if (hand != null) {
            stack.addHand(hand);
        }
        if (enchantments != null) {
            stack.addEnchantments(enchantments);
        }
        if (enchantmentLevels != null) {
            stack.addEnchantRange(enchantmentLevels);
        }
        if (damageMask != null) {
            stack.addDamageMask(damageMask);
        }
        return stack;
    }

    private static NBTCondition setNbtCondition(String nbtPath, String value) {
        if (value.startsWith("contains:")) {
            return new NBTCondition(nbtPath, NBTCondition.Type.CONTAINS, value.substring(9));
        }
        if (value.startsWith("regex:")) {
            return new NBTCondition(nbtPath, NBTCondition.Type.REGEX, value.substring(6));
        }
        if (value.startsWith("icontains:")) {
            return new NBTCondition(nbtPath, NBTCondition.Type.ICONTAINS, value.substring(10));
        }
        if (value.startsWith("iregex:")) {
            return new NBTCondition(nbtPath, NBTCondition.Type.IREGEX, value.substring(7));
        }
        if (value.startsWith("exists:")) {
            String bool = value.substring(7);
            if (bool.equalsIgnoreCase("true") || bool.equalsIgnoreCase("false")) {
                return new NBTCondition(nbtPath, NBTCondition.Type.EXISTS, value.substring(7));
            }
            CITNBT.LOGGER.warn("Unable to apply exists rule on path {}: Invalid value: {}", (Object)nbtPath, (Object)bool);
        } else {
            if (value.startsWith("range:")) {
                List<String> range = Arrays.asList(value.substring(6).split(" "));
                ArrayList<Range> ranges = new ArrayList<Range>();
                range.forEach(subRange -> ranges.add(Range.parse(subRange, 0, 65535)));
                return new NBTCondition(nbtPath, NBTCondition.Type.RANGE, ranges);
            }
            if (value.startsWith("raw:")) {
                return new NBTCondition(nbtPath, NBTCondition.Type.RAW, value.substring(4));
            }
        }
        return new NBTCondition(nbtPath, NBTCondition.Type.EQUALS, value);
    }

    public static void clearRules() {
        ITEM_RULES.clear();
    }

    private static int tryParseInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

