/*
 * Decompiled with CFR 0.152.
 */
package com.sabrepotato.citnbt.resources;

import com.google.gson.JsonParser;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;

public class FlattenedResourcePack
implements IResourcePack {
    private final File base;

    public FlattenedResourcePack(File base) {
        this.base = base;
    }

    public InputStream getInputStream(ResourceLocation location) throws IOException {
        File file = this.resolve(location);
        if (file.isFile()) {
            return new FileInputStream(file);
        }
        throw new FileNotFoundException(location.toString());
    }

    public boolean resourceExists(ResourceLocation location) {
        return this.resolve(location).isFile();
    }

    public Set<String> getResourceDomains() {
        File[] dirs = this.base.listFiles(File::isDirectory);
        HashSet<String> domains = new HashSet<String>();
        if (dirs != null) {
            for (File dir : dirs) {
                domains.add(dir.getName());
            }
        }
        return domains;
    }

    public <T extends IMetadataSection> T getPackMetadata(MetadataSerializer serializer, String section) throws IOException {
        File meta = new File(this.base, "pack.mcmeta");
        if (!meta.isFile()) {
            return null;
        }
        try (FileReader reader = new FileReader(meta);){
            JsonParser parser = new JsonParser();
            IMetadataSection iMetadataSection = serializer.parseMetadataSection(section, parser.parse((Reader)reader).getAsJsonObject());
            return (T)iMetadataSection;
        }
    }

    public BufferedImage getPackImage() throws IOException {
        throw new FileNotFoundException("No pack.png");
    }

    public String getPackName() {
        return "Flat Resource Folder";
    }

    private File resolve(ResourceLocation location) {
        return new File(this.base, new File(location.getNamespace(), location.getPath()).getPath());
    }
}

