/*
 * Decompiled with CFR 0.152.
 */
package com.sabrepotato.citnbt.resources;

import com.sabrepotato.citnbt.resources.conditions.ItemstackCondition;
import com.sabrepotato.citnbt.resources.conditions.NBTCondition;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.Nullable;

public class ItemRule {
    public final List<NBTCondition> conditions;
    public final ItemstackCondition stackCondition;
    public final ModelResourceLocation location;

    public ItemRule(List<NBTCondition> conditions, ModelResourceLocation location, ItemstackCondition itemstackCondition) {
        this.conditions = conditions;
        this.location = location;
        this.stackCondition = itemstackCondition;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemRule)) {
            return false;
        }
        ItemRule other = (ItemRule)obj;
        return Objects.equals(this.conditions, other.conditions);
    }

    public boolean matches(ItemStack stack, @Nullable EntityLivingBase player) {
        NBTTagCompound compound = stack.getTagCompound();
        for (NBTCondition condition : this.conditions) {
            if (condition.matches(compound)) continue;
            return false;
        }
        return this.stackCondition.checkConditions(stack, player);
    }

    public int hashCode() {
        return Objects.hash(this.conditions.hashCode(), this.stackCondition);
    }

    public ModelResourceLocation getLocation() {
        return this.location;
    }
}

