/*
 * Decompiled with CFR 0.152.
 */
package com.sabrepotato.citnbt.resources.conditions;

import com.sabrepotato.citnbt.CITNBT;
import com.sabrepotato.citnbt.config.CITNBTConfig;
import com.sabrepotato.citnbt.resources.conditions.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ItemstackCondition {
    private List<Range> damageRange;
    private Integer damageMask;
    private Float percentageLow;
    private Float percentageHigh;
    private List<Range> stackRange;
    private List<Enchantment> enchantments;
    private List<Range> levelRange;
    private EnumHand hand;

    public void addDamageRange(Range range) {
        if (this.damageRange == null) {
            this.damageRange = new ArrayList<Range>();
        }
        this.damageRange.add(range);
    }

    public void addStackRange(Range range) {
        if (this.stackRange == null) {
            this.stackRange = new ArrayList<Range>();
        }
        this.stackRange.add(range);
    }

    public void addEnchantment(Enchantment enchantment) {
        if (this.enchantments == null) {
            this.enchantments = new ArrayList<Enchantment>();
        }
        this.enchantments.add(enchantment);
    }

    public void addLevel(Range level) {
        if (this.levelRange == null) {
            this.levelRange = new ArrayList<Range>();
        }
        this.levelRange.add(level);
    }

    public void setDamageMask(int damageMask) {
        this.damageMask = damageMask;
    }

    public void setPercentage(int low, int high) {
        this.percentageLow = Float.valueOf((float)low / 100.0f);
        this.percentageHigh = Float.valueOf((float)high / 100.0f);
    }

    public void setPercentage(int percentage) {
        this.percentageLow = Float.valueOf((float)percentage / 100.0f);
    }

    public void addHand(String hand) {
        if (hand.equalsIgnoreCase("any")) {
            this.hand = null;
        } else if (hand.equalsIgnoreCase("off")) {
            this.hand = EnumHand.OFF_HAND;
        } else if (hand.equalsIgnoreCase("main")) {
            this.hand = EnumHand.MAIN_HAND;
        }
    }

    public boolean checkConditions(ItemStack itemStack, @Nullable EntityLivingBase entity) {
        if (this.damageRange != null) {
            int damage = itemStack.getItemDamage();
            if (this.damageMask != null) {
                damage &= this.damageMask.intValue();
            }
            int finalDamage = damage;
            boolean result = this.damageRange.stream().anyMatch(range -> range.contains(finalDamage));
            if (!result) {
                return false;
            }
        }
        if (this.percentageLow != null) {
            int maxDamage = itemStack.getMaxDamage();
            int currentDamage = itemStack.getItemDamage();
            if (this.percentageHigh != null ? Math.round(this.percentageLow.floatValue() * (float)maxDamage) > currentDamage || currentDamage > Math.round(this.percentageHigh.floatValue() * (float)maxDamage) : Math.round(this.percentageLow.floatValue() * (float)maxDamage) != currentDamage) {
                return false;
            }
        }
        if (this.stackRange != null) {
            int count = itemStack.getCount();
            boolean result = this.stackRange.stream().anyMatch(range -> range.contains(count));
            if (!result) {
                return false;
            }
        }
        if (this.enchantments != null && (this.levelRange != null ? (CITNBTConfig.compat.matchOneEnchAndLevel ? this.enchantments.stream().noneMatch(ench -> this.levelRange.stream().anyMatch(range -> range.contains(EnchantmentHelper.getEnchantmentLevel((Enchantment)ench, (ItemStack)itemStack)))) : !this.enchantments.stream().allMatch(ench -> this.levelRange.stream().anyMatch(range -> range.contains(EnchantmentHelper.getEnchantmentLevel((Enchantment)ench, (ItemStack)itemStack))))) : (CITNBTConfig.compat.matchOneEnchAndLevel ? this.enchantments.stream().noneMatch(ench -> EnchantmentHelper.getEnchantmentLevel((Enchantment)ench, (ItemStack)itemStack) != 0) : !this.enchantments.stream().allMatch(ench -> EnchantmentHelper.getEnchantmentLevel((Enchantment)ench, (ItemStack)itemStack) != 0)))) {
            return false;
        }
        if (this.levelRange != null && this.enchantments == null && EnchantmentHelper.getEnchantments((ItemStack)itemStack).values().stream().noneMatch(level -> this.levelRange.stream().anyMatch(range -> range.contains((int)level)))) {
            return false;
        }
        if (this.hand != null && entity != null) {
            switch (this.hand) {
                case OFF_HAND: {
                    if (itemStack == entity.getHeldItemOffhand()) break;
                    return false;
                }
                case MAIN_HAND: {
                    if (!(CITNBTConfig.compat.differentModelInInventoryFromHand ? itemStack == entity.getHeldItemOffhand() : itemStack != entity.getHeldItemMainhand())) break;
                    return false;
                }
            }
        }
        return true;
    }

    public void addDamageRule(String damageRange) {
        if (damageRange.startsWith("range:")) {
            List<String> range = Arrays.asList(damageRange.substring(6).split(" "));
            range.forEach(subRange -> this.addDamageRange(Range.parse(subRange, 0, 65535)));
        } else if (damageRange.contains("%")) {
            List<String> percentRange = Arrays.asList(damageRange.split(" "));
            if (percentRange.size() == 1) {
                this.setPercentage(Integer.parseInt(percentRange.get(0).replace("%", "")));
            } else if (percentRange.size() == 2) {
                int high;
                int low = Integer.parseInt(percentRange.get(0).replace("%", ""));
                if (low > (high = Integer.parseInt(percentRange.get(1).replace("%", "")))) {
                    int temp = low;
                    low = high;
                    high = temp;
                }
                this.setPercentage(low, high);
            } else {
                CITNBT.LOGGER.error("Invalid count of percentages. Only 1 or 2 allowed: {}", (Object)damageRange);
            }
        } else {
            try {
                this.addDamageRange(Range.parse(damageRange, 0, 65535));
            }
            catch (NumberFormatException e) {
                CITNBT.LOGGER.error("Not a valid integer: {}", (Object)damageRange);
            }
        }
    }

    public void addDamageMask(String damageMask) {
        try {
            this.setDamageMask(Integer.parseInt(damageMask));
        }
        catch (NumberFormatException e) {
            CITNBT.LOGGER.error("Not a valid integer: {}", (Object)damageMask);
        }
    }

    public void addStackRule(String stackRange) {
        if (stackRange.startsWith("range:")) {
            List<String> range = Arrays.asList(stackRange.substring(6).split(" "));
            range.forEach(subRange -> this.addStackRange(Range.parse(subRange, 0, 65535)));
        } else {
            try {
                this.addStackRange(Range.parse(stackRange, 0, 65535));
            }
            catch (NumberFormatException e) {
                CITNBT.LOGGER.error("Not a valid integer: {}", (Object)stackRange);
            }
        }
    }

    public void addEnchantments(String enchantments) {
        List<String> splitString = Arrays.asList(enchantments.split(" "));
        splitString.forEach(e -> {
            ResourceLocation loc = e.contains(":") ? new ResourceLocation(e) : new ResourceLocation("minecraft", e);
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(loc);
            if (enchantment != null) {
                this.addEnchantment(enchantment);
            } else {
                CITNBT.LOGGER.error("Not a valid registry: {}", (Object)loc);
            }
        });
    }

    public void addEnchantRange(String levels) {
        List<String> splitString = Arrays.asList(levels.split(" "));
        splitString.forEach(subrange -> splitString.forEach(subRange -> this.addLevel(Range.parse(subrange, 0, 65535))));
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemstackCondition that = (ItemstackCondition)o;
        return Objects.equals(this.damageRange, that.damageRange) && Objects.equals(this.damageMask, that.damageMask) && Objects.equals(this.percentageLow, that.percentageLow) && Objects.equals(this.percentageHigh, that.percentageHigh) && Objects.equals(this.stackRange, that.stackRange) && Objects.equals(this.enchantments, that.enchantments) && Objects.equals(this.levelRange, that.levelRange) && this.hand == that.hand;
    }

    public int hashCode() {
        return Objects.hash(this.damageRange, this.damageMask, this.percentageLow, this.percentageHigh, this.stackRange, this.enchantments, this.levelRange, this.hand);
    }
}

