/*
 * Decompiled with CFR 0.152.
 */
package com.sabrepotato.citnbt.resources.conditions;

import com.sabrepotato.citnbt.resources.conditions.Range;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTCondition {
    private final String nbtPath;
    private final Type type;
    private final String expectedValue;
    private final Pattern pattern;
    private final boolean shouldTagExist;
    private final List<Range> range;

    public NBTCondition(String nbtPath, Type type, String expectedValue) {
        this.nbtPath = nbtPath;
        this.type = type;
        this.expectedValue = expectedValue;
        this.pattern = type == Type.CONTAINS ? this.toEscapedPattern(expectedValue, false) : (type == Type.ICONTAINS ? this.toEscapedPattern(expectedValue, true) : (type == Type.IREGEX ? Pattern.compile(expectedValue, 2) : (type == Type.REGEX ? Pattern.compile(expectedValue) : null)));
        this.shouldTagExist = expectedValue.equalsIgnoreCase("true");
        this.range = null;
    }

    public NBTCondition(String nbtPath, Type type, List<Range> rangeValue) {
        this.nbtPath = nbtPath;
        this.type = type;
        this.expectedValue = null;
        this.pattern = null;
        this.shouldTagExist = true;
        this.range = rangeValue;
    }

    public boolean matches(NBTTagCompound compound) {
        boolean bl;
        if (compound == null) {
            return this.type == Type.EXISTS && !this.shouldTagExist;
        }
        NBTTagCompound current = compound;
        if (!this.nbtPath.isEmpty()) {
            for (String key : this.nbtPath.split("\\.")) {
                if (!(current instanceof NBTTagCompound)) {
                    return false;
                }
                if ((current = current.getTag(key)) != null) continue;
                return this.type == Type.EXISTS && !this.shouldTagExist;
            }
        }
        if (this.type == Type.EXISTS) {
            return this.shouldTagExist;
        }
        if (this.type == Type.RANGE) {
            return this.isValueInRange((NBTBase)current);
        }
        if (this.type == Type.RAW) {
            return current.toString().equals(this.expectedValue);
        }
        String actual = this.getValueAsString((NBTBase)current);
        if (actual == null) {
            return false;
        }
        switch (this.type) {
            case EQUALS: {
                bl = actual.equals(this.expectedValue);
                break;
            }
            case CONTAINS: 
            case ICONTAINS: 
            case REGEX: 
            case IREGEX: {
                bl = this.pattern.matcher(actual).find();
                break;
            }
            case NOT_EQUALS: {
                if (!actual.equals(this.expectedValue)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private Pattern toEscapedPattern(String input, boolean caseInsensitive) {
        StringBuilder builder = new StringBuilder();
        block5: for (char c : input.toCharArray()) {
            switch (c) {
                case '*': {
                    builder.append(".*");
                    continue block5;
                }
                case '?': {
                    builder.append('.');
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    builder.append('\\').append(c);
                    continue block5;
                }
                default: {
                    builder.append(c);
                }
            }
        }
        if (caseInsensitive) {
            return Pattern.compile(builder.toString(), 2);
        }
        return Pattern.compile(builder.toString());
    }

    private String getValueAsString(NBTBase tag) {
        if (tag instanceof NBTTagString) {
            return ((NBTTagString)tag).getString();
        }
        if (tag instanceof NBTTagByte) {
            return Byte.toString(((NBTTagByte)tag).getByte());
        }
        if (tag instanceof NBTTagInt) {
            return Integer.toString(((NBTTagInt)tag).getInt());
        }
        if (tag instanceof NBTTagLong) {
            return Long.toString(((NBTTagLong)tag).getLong());
        }
        if (tag instanceof NBTTagFloat) {
            return Float.toString(((NBTTagFloat)tag).getFloat());
        }
        if (tag instanceof NBTTagDouble) {
            return Double.toString(((NBTTagDouble)tag).getDouble());
        }
        return null;
    }

    private boolean isValueInRange(NBTBase tag) {
        for (Range r : this.range) {
            if (tag instanceof NBTTagInt && r.contains(((NBTTagInt)tag).getInt())) {
                return true;
            }
            if (tag instanceof NBTTagLong && r.contains(((NBTTagLong)tag).getLong())) {
                return true;
            }
            if (tag instanceof NBTTagShort && r.contains(((NBTTagShort)tag).getShort())) {
                return true;
            }
            if (tag instanceof NBTTagDouble && r.contains(((NBTTagDouble)tag).getDouble())) {
                return true;
            }
            if (!(tag instanceof NBTTagFloat) || !r.contains(((NBTTagFloat)tag).getFloat())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBTCondition that = (NBTCondition)o;
        return Objects.equals(this.nbtPath, that.nbtPath) && this.type == that.type && Objects.equals(this.expectedValue, that.expectedValue) && Objects.equals(this.range, that.range);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.nbtPath, this.type, this.expectedValue, this.range});
    }

    public static enum Type {
        EQUALS,
        CONTAINS,
        ICONTAINS,
        REGEX,
        IREGEX,
        EXISTS,
        NOT_EQUALS,
        RANGE,
        RAW;

    }
}

