/*
 * Decompiled with CFR 0.152.
 */
package com.sabrepotato.citnbt.resources.conditions;

import com.sabrepotato.citnbt.CITNBT;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Range {
    final int start;
    final int end;
    private static final Pattern pattern = Pattern.compile("^(\\(-?\\d+\\)|-?\\d+)(?:-(\\(-?\\d+\\)|\\d+)?)?$");

    Range(int start, int end) {
        if (start > end) {
            this.end = start;
            this.start = end;
        } else {
            this.start = start;
            this.end = end;
        }
    }

    boolean contains(int value) {
        return value >= this.start && value <= this.end;
    }

    boolean contains(long value) {
        return value >= (long)this.start && value <= (long)this.end;
    }

    boolean contains(short value) {
        return value >= this.start && value <= this.end;
    }

    boolean contains(float value) {
        return value >= (float)this.start && value <= (float)this.end;
    }

    boolean contains(double value) {
        return value >= (double)this.start && value <= (double)this.end;
    }

    public static Range parse(String input, int minVal, int maxVal) {
        int end;
        Matcher matcher = pattern.matcher(input.trim());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid range format: " + input);
        }
        int start = Integer.parseInt(matcher.group(1).replace("(", "").replace(")", ""));
        if (start < minVal) {
            start = minVal;
        }
        String endstr = matcher.group(2);
        if (input.endsWith("-") && endstr == null) {
            end = maxVal;
        } else if (endstr != null) {
            end = Integer.parseInt(endstr.replace("(", "").replace(")", ""));
            if (end < minVal) {
                CITNBT.LOGGER.warn("Upper limit is below minimum value {}: {}", (Object)minVal, (Object)end);
                end = minVal;
            }
            if (end > maxVal) {
                CITNBT.LOGGER.warn("Upper limit is above maximum value {}: {}", (Object)maxVal, (Object)end);
                end = maxVal;
            }
        } else {
            end = start;
        }
        return new Range(start, end);
    }

    public static Range parse(String input) {
        return Range.parse(input, 0, 65535);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        return this.start == range.start && this.end == range.end;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }
}

