/*
 * Decompiled with CFR 0.152.
 */
package com.sabrepotato.citnbt.client;

import com.sabrepotato.citnbt.client.TextureModelHandler;
import com.sabrepotato.citnbt.resources.NBTRule;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class DynamicBakedModel
implements IBakedModel {
    private final IBakedModel defaultModel;
    private final List<NBTRule> rules;

    public DynamicBakedModel(IBakedModel defaultModel, List<NBTRule> rules) {
        this.defaultModel = defaultModel;
        this.rules = rules;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState iBlockState, @Nullable EnumFacing enumFacing, long rand) {
        return this.defaultModel.func_188616_a(iBlockState, enumFacing, rand);
    }

    public boolean func_177555_b() {
        return this.defaultModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.defaultModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.defaultModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.defaultModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.defaultModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return new ItemOverrideList(Collections.emptyList()){

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                for (NBTRule rule : DynamicBakedModel.this.rules) {
                    IBakedModel bake;
                    if (!rule.matches(stack) || (bake = TextureModelHandler.BAKED_MODELS.get(rule)) == null) continue;
                    return bake;
                }
                return DynamicBakedModel.this.defaultModel;
            }
        };
    }

    public boolean isAmbientOcclusion(IBlockState state) {
        return this.defaultModel.isAmbientOcclusion(state);
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return this.defaultModel.handlePerspective(cameraTransformType);
    }
}

