/*
 * Decompiled with CFR 0.152.
 */
package com.sabrepotato.citnbt.client;

import com.google.common.collect.ImmutableMap;
import com.sabrepotato.citnbt.CITNBT;
import com.sabrepotato.citnbt.client.DynamicBakedModel;
import com.sabrepotato.citnbt.config.FileNBTLoader;
import com.sabrepotato.citnbt.config.NBTHolder;
import com.sabrepotato.citnbt.resources.NBTRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber
public class TextureModelHandler {
    public static final Map<NBTRule, IBakedModel> BAKED_MODELS = new HashMap<NBTRule, IBakedModel>();
    private static final Map<ModelResourceLocation, List<NBTRule>> RULES_BY_MODEL = new HashMap<ModelResourceLocation, List<NBTRule>>();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        FileNBTLoader.loadFiles();
        for (NBTHolder rule : FileNBTLoader.CONFIG_RULES) {
            if (rule.texture == null) continue;
            event.getMap().func_174942_a(rule.texture);
        }
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        FileNBTLoader.clearRules();
        FileNBTLoader.loadFiles();
        BAKED_MODELS.clear();
        RULES_BY_MODEL.clear();
        for (NBTHolder nBTHolder : FileNBTLoader.CONFIG_RULES) {
            try {
                NBTRule rule = nBTHolder.getRule();
                ModelResourceLocation targetModel = rule.getLocation();
                IModel model = nBTHolder.getModel() != null ? ModelLoaderRegistry.getModel((ResourceLocation)nBTHolder.getModel()) : (nBTHolder.getTexture() != null ? ModelLoaderRegistry.getModel((ResourceLocation)targetModel).retexture(ImmutableMap.of((Object)"layer0", (Object)nBTHolder.getTexture().toString())) : ModelLoaderRegistry.getModel((ResourceLocation)targetModel));
                IBakedModel bakedModel = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
                BAKED_MODELS.put(rule, bakedModel);
                RULES_BY_MODEL.computeIfAbsent(targetModel, k -> new ArrayList()).add(rule);
            }
            catch (Exception e) {
                CITNBT.LOGGER.error("Error baking model for rule: {}", (Object)nBTHolder.getRule());
            }
        }
        for (Map.Entry entry : RULES_BY_MODEL.entrySet()) {
            ModelResourceLocation modelLoc = (ModelResourceLocation)entry.getKey();
            List rules = (List)entry.getValue();
            IBakedModel original = (IBakedModel)event.getModelRegistry().func_82594_a((Object)modelLoc);
            if (original != null) {
                DynamicBakedModel wrapped = new DynamicBakedModel(original, rules);
                event.getModelRegistry().func_82595_a((Object)modelLoc, (Object)wrapped);
                continue;
            }
            CITNBT.LOGGER.error("Invalid target: {}", (Object)modelLoc);
        }
    }
}

