/*
 * Decompiled with CFR 0.152.
 */
package com.sabrepotato.citnbt.config;

import com.sabrepotato.citnbt.CITNBT;
import com.sabrepotato.citnbt.config.NBTHolder;
import com.sabrepotato.citnbt.resources.NBTCondition;
import com.sabrepotato.citnbt.resources.NBTRule;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;

public class FileNBTLoader {
    public static List<NBTHolder> CONFIG_RULES = new ArrayList<NBTHolder>();

    public static void loadFiles() {
        File resourceDir = new File(Minecraft.func_71410_x().field_71412_D, "resources");
        if (resourceDir.exists() && resourceDir.isDirectory()) {
            try (Stream<Path> stream = Files.walk(resourceDir.toPath(), new FileVisitOption[0]);){
                stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".properties")).forEach(path -> {
                    CITNBT.LOGGER.info("Loaded file {}", (Object)path.toString());
                    try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                        Properties props = new Properties();
                        props.load(in);
                        List<String> items = Arrays.asList(props.getProperty("items").split(" "));
                        String texture = props.getProperty("texture");
                        String model = props.getProperty("model");
                        if (items.isEmpty() || texture == null && model == null) {
                            return;
                        }
                        List<ModelResourceLocation> itemLocs = items.stream().map(item -> new ModelResourceLocation(item, "inventory")).collect(Collectors.toList());
                        ResourceLocation textureLoc = texture != null ? new ResourceLocation(texture) : null;
                        ResourceLocation modelLoc = model != null ? new ResourceLocation(model) : null;
                        ArrayList<NBTCondition> rules = new ArrayList<NBTCondition>();
                        for (String key : props.stringPropertyNames()) {
                            if (!key.startsWith("nbt.")) continue;
                            String nbtPath = key.substring(4);
                            String val = props.getProperty(key);
                            if (val.startsWith("contains:")) {
                                rules.add(new NBTCondition(nbtPath, NBTCondition.Type.CONTAINS, val.substring(9)));
                                continue;
                            }
                            if (val.startsWith("icontains:")) {
                                rules.add(new NBTCondition(nbtPath, NBTCondition.Type.ICONTAINS, val.substring(10)));
                                continue;
                            }
                            if (val.startsWith("exists:")) {
                                String bool = val.substring(7);
                                if (bool.equalsIgnoreCase("true") || bool.equalsIgnoreCase("false")) {
                                    rules.add(new NBTCondition(nbtPath, NBTCondition.Type.EXISTS, val.substring(7)));
                                    continue;
                                }
                                CITNBT.LOGGER.warn("Unable to apply exists rule to {} on path {}: Invalid value: {}", itemLocs, (Object)nbtPath, (Object)bool);
                                continue;
                            }
                            rules.add(new NBTCondition(nbtPath, NBTCondition.Type.EQUALS, val));
                        }
                        itemLocs.forEach(itemLoc -> {
                            NBTRule rule = new NBTRule((List<NBTCondition>)rules, (ModelResourceLocation)itemLoc);
                            CONFIG_RULES.add(new NBTHolder(textureLoc, modelLoc, rule));
                        });
                    }
                    catch (IOException e) {
                        CITNBT.LOGGER.error("Unable to read file {}", path);
                    }
                    catch (NullPointerException e) {
                        CITNBT.LOGGER.error("Could not create an array, you might be missing an items property");
                    }
                });
            }
            catch (Exception e) {
                CITNBT.LOGGER.error("Unable to read directory {}", (Object)resourceDir.toPath());
            }
        }
    }

    public static void clearRules() {
        CONFIG_RULES.clear();
    }
}

