/*
 * Decompiled with CFR 0.152.
 */
package com.sabrepotato.citnbt.resources;

import com.sabrepotato.citnbt.CITNBT;
import com.sabrepotato.citnbt.resources.FlattenedResourcePack;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultResourcePack;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ExternalResourcePack {
    private static final File RESOURCE_DIR = new File(Minecraft.func_71410_x().field_71412_D, "resources");
    private static final File PACK_META = new File(RESOURCE_DIR, "pack.mcmeta");

    public static void ensurePackMcmetaExists() {
        if (!PACK_META.exists()) {
            try {
                String json = "{ \"pack\": { \"pack_format\": 3, \"description\": \"Auto CIT Resource\" } }";
                Files.write(PACK_META.toPath(), json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                CITNBT.LOGGER.error("Unable to generate mcmeta: {}. This mod will not work, as it cannot force loading a resource pack. This is not a critical mod, so this will not force a stop.", (Object)e.getLocalizedMessage());
            }
        }
    }

    public static void injectExternalResources() {
        File resourceDir = new File(Minecraft.func_71410_x().field_71412_D, "resources");
        FlattenedResourcePack flatPack = new FlattenedResourcePack(resourceDir);
        Minecraft mc = Minecraft.func_71410_x();
        try {
            IResourceManager rm;
            List defaultPacks = (List)ObfuscationReflectionHelper.getPrivateValue(Minecraft.class, (Object)mc, (String[])new String[]{"defaultResourcePacks", "field_110449_ao"});
            if (!defaultPacks.contains(flatPack)) {
                defaultPacks.add(flatPack);
            }
            CITNBT.LOGGER.info("Loaded FlatResourcePack: ./resources");
            ArrayList<DefaultResourcePack> allPacks = new ArrayList<DefaultResourcePack>(defaultPacks);
            DefaultResourcePack mcPack = mc.field_110450_ap;
            if (!allPacks.contains(mcPack)) {
                allPacks.add(mcPack);
            }
            if ((rm = mc.func_110442_L()) instanceof SimpleReloadableResourceManager) {
                ((SimpleReloadableResourceManager)rm).func_110541_a(allPacks);
            }
        }
        catch (Exception e) {
            CITNBT.LOGGER.error("Unable to load resources: {}", (Object)e.getLocalizedMessage());
        }
    }
}

