/*
 * Decompiled with CFR 0.152.
 */
package com.sabrepotato.citnbt.resources;

import java.util.regex.Pattern;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagString;

public class NBTCondition {
    private final String nbtPath;
    private final Type type;
    private final String expectedValue;
    private final boolean shouldTagExist;

    public NBTCondition(String nbtPath, Type type, String expectedValue) {
        this.nbtPath = nbtPath;
        this.type = type;
        this.expectedValue = expectedValue;
        this.shouldTagExist = expectedValue.equalsIgnoreCase("true");
    }

    public boolean matches(NBTTagCompound compound) {
        boolean bl;
        if (compound == null) {
            return this.type == Type.EXISTS && !this.shouldTagExist;
        }
        NBTTagCompound current = compound;
        for (String key : this.nbtPath.split("\\.")) {
            if (!(current instanceof NBTTagCompound)) {
                return false;
            }
            if ((current = current.func_74781_a(key)) != null) continue;
            return this.type == Type.EXISTS && !this.shouldTagExist;
        }
        if (this.type == Type.EXISTS) {
            return this.shouldTagExist;
        }
        String actual = this.getValueAsString((NBTBase)current);
        if (actual == null) {
            return false;
        }
        switch (this.type) {
            case EQUALS: {
                bl = actual.equals(this.expectedValue);
                break;
            }
            case CONTAINS: {
                bl = Pattern.compile(Pattern.quote(this.expectedValue)).matcher(actual).find();
                break;
            }
            case ICONTAINS: {
                bl = Pattern.compile(Pattern.quote(this.expectedValue), 2).matcher(actual).find();
                break;
            }
            case NOT_EQUALS: {
                if (!actual.equals(this.expectedValue)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private String getValueAsString(NBTBase tag) {
        if (tag instanceof NBTTagString) {
            return ((NBTTagString)tag).func_150285_a_();
        }
        if (tag instanceof NBTTagByte) {
            return Byte.toString(((NBTTagByte)tag).func_150290_f());
        }
        if (tag instanceof NBTTagInt) {
            return Integer.toString(((NBTTagInt)tag).func_150287_d());
        }
        if (tag instanceof NBTTagLong) {
            return Long.toString(((NBTTagLong)tag).func_150291_c());
        }
        if (tag instanceof NBTTagFloat) {
            return Float.toString(((NBTTagFloat)tag).func_150288_h());
        }
        if (tag instanceof NBTTagDouble) {
            return Double.toString(((NBTTagDouble)tag).func_150286_g());
        }
        return null;
    }

    public static enum Type {
        EQUALS,
        CONTAINS,
        ICONTAINS,
        EXISTS,
        NOT_EQUALS;

    }
}

