/*
 * Decompiled with CFR 0.152.
 */
package com.sabrepotato.citnbt.resources;

import com.sabrepotato.citnbt.resources.NBTCondition;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class NBTRule {
    public final List<NBTCondition> conditions;
    public final ModelResourceLocation location;

    public NBTRule(List<NBTCondition> conditions, ModelResourceLocation location) {
        this.conditions = conditions;
        this.location = location;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NBTRule)) {
            return false;
        }
        NBTRule other = (NBTRule)obj;
        return Objects.equals(this.conditions, other.conditions);
    }

    public boolean matches(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        for (NBTCondition condition : this.conditions) {
            if (condition.matches(compound)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.conditions);
    }

    public ModelResourceLocation getLocation() {
        return this.location;
    }
}

