/*
 * Decompiled with CFR 0.152.
 */
package com.github.mahmudindev.mcmod.worldportal.portal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class PortalReturns
extends SavedData {
    public static final Codec<PortalReturns> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PortalReturn.CODEC.listOf().fieldOf("Dimensions").forGetter(v -> {
        ArrayList portalReturns = new ArrayList();
        v.dimensions.forEach((blockPos, resourceKey) -> portalReturns.add(new PortalReturn((BlockPos)blockPos, (ResourceKey<Level>)resourceKey)));
        return portalReturns;
    })).apply((Applicative)instance, v -> {
        HashMap<BlockPos, ResourceKey<Level>> dimensions = new HashMap<BlockPos, ResourceKey<Level>>();
        v.forEach(portalReturn -> dimensions.put(portalReturn.blockPos, portalReturn.resourceKey));
        return new PortalReturns(dimensions);
    }));
    public static SavedDataType<PortalReturns> TYPE = new SavedDataType("worldportal_returns", PortalReturns::new, CODEC, null);
    private final Map<BlockPos, ResourceKey<Level>> dimensions;

    public PortalReturns() {
        this.dimensions = new HashMap<BlockPos, ResourceKey<Level>>();
        this.setDirty();
    }

    private PortalReturns(Map<BlockPos, ResourceKey<Level>> dimensions) {
        this.dimensions = dimensions;
    }

    public Map<BlockPos, ResourceKey<Level>> getDimensions() {
        return Map.copyOf(this.dimensions);
    }

    public ResourceKey<Level> getDimension(BlockPos pos) {
        return this.dimensions.get(pos);
    }

    public void putDimension(BlockPos pos, ResourceKey<Level> dimension) {
        this.dimensions.put(pos, dimension);
        this.setDirty();
    }

    public void removeDimension(BlockPos pos) {
        this.dimensions.remove(pos);
        this.setDirty();
    }

    record PortalReturn(BlockPos blockPos, ResourceKey<Level> resourceKey) {
        static final Codec<PortalReturn> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("PosX").forGetter(v -> v.blockPos.getX()), (App)Codec.INT.fieldOf("PosY").forGetter(v -> v.blockPos.getY()), (App)Codec.INT.fieldOf("PosZ").forGetter(v -> v.blockPos.getZ()), (App)ResourceLocation.CODEC.fieldOf("Dimension").forGetter(v -> v.resourceKey.location())).apply((Applicative)instance, (x, y, z, resourceLocation) -> new PortalReturn(new BlockPos(x.intValue(), y.intValue(), z.intValue()), (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)resourceLocation))));
    }
}

