/*
 * Decompiled with CFR 0.152.
 */
package com.github.mahmudindev.mcmod.worldportal.portal;

import com.github.mahmudindev.mcmod.worldportal.WorldPortal;
import com.github.mahmudindev.mcmod.worldportal.config.Config;
import com.github.mahmudindev.mcmod.worldportal.portal.PortalData;
import com.google.gson.Gson;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class PortalManager {
    private static final Map<class_2960, PortalData> PORTALS = new HashMap<class_2960, PortalData>();

    public static void onResourceManagerReload(class_3300 manager) {
        PORTALS.clear();
        Config config = Config.getConfig();
        config.getPortals().forEach((id, portal) -> PortalManager.setPortal(class_2960.method_60654((String)id), portal));
        Gson gson = new Gson();
        manager.method_14488("worldportal", resourceLocation -> resourceLocation.method_12832().endsWith(".json")).forEach((resourceLocation, resource) -> {
            String resourcePath = resourceLocation.method_12832().replaceFirst("^%s/".formatted("worldportal"), "");
            if (!resourcePath.startsWith("portal/")) {
                return;
            }
            try {
                String portalPath = resourcePath.substring(resourcePath.indexOf("/") + 1).replaceAll("\\.json$", "");
                PortalManager.setPortal(resourceLocation.method_45136(portalPath), (PortalData)gson.fromJson(JsonParser.parseReader((Reader)resource.method_43039()), PortalData.class));
            }
            catch (IOException e) {
                WorldPortal.LOGGER.error("Failed to read datapack", (Throwable)e);
            }
        });
    }

    public static Map<class_2960, PortalData> getPortals() {
        return Map.copyOf(PORTALS);
    }

    public static PortalData getPortal(class_2960 id) {
        return PORTALS.get(id);
    }

    public static void setPortal(class_2960 id, PortalData portal) {
        PORTALS.put(id, portal);
    }
}

