/*
 * Decompiled with CFR 0.152.
 */
package com.github.mahmudindev.mcmod.worldportal.mixin;

import com.github.mahmudindev.mcmod.worldportal.base.IEntity;
import com.github.mahmudindev.mcmod.worldportal.base.IServerLevel;
import com.github.mahmudindev.mcmod.worldportal.portal.PortalData;
import com.github.mahmudindev.mcmod.worldportal.portal.PortalManager;
import com.github.mahmudindev.mcmod.worldportal.portal.PortalReturns;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.TeleportTransition;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements IEntity {
    @Unique
    private ResourceLocation portalId;

    @Shadow
    public abstract Level level();

    @WrapOperation(method={"handlePortal()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;teleport(Lnet/minecraft/world/level/portal/TeleportTransition;)Lnet/minecraft/world/entity/Entity;")})
    private Entity handlePortalChangeDimensionFinish(Entity instance, TeleportTransition teleportTransition, Operation<Entity> original) {
        PortalData portal = this.worldportal$getPortal();
        if (portal != null) {
            ServerLevel serverLevel = teleportTransition.newLevel();
            ResourceKey dimension = serverLevel.dimension();
            if (dimension != portal.getDestinationKey()) {
                return (Entity)original.call(new Object[]{instance, teleportTransition});
            }
            BlockPos blockPos = BlockPos.containing((Position)teleportTransition.position());
            BlockState blockState = serverLevel.getBlockState(blockPos);
            boolean hasHA = blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS);
            Direction.Axis axis = hasHA ? (Direction.Axis)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS) : Direction.Axis.X;
            BlockUtil.FoundRectangle foundRectangle = BlockUtil.getLargestRectangleAround((BlockPos)blockPos, (Direction.Axis)axis, (int)21, (Direction.Axis)(hasHA ? Direction.Axis.Y : Direction.Axis.X), (int)21, blockPosX -> serverLevel.getBlockState(blockPosX) == blockState);
            IServerLevel serverLevelX = (IServerLevel)serverLevel;
            PortalReturns portalReturns = serverLevelX.worldportal$getPortalReturns();
            portalReturns.putDimension(foundRectangle.minCorner, (ResourceKey<Level>)this.level().dimension());
        }
        return (Entity)original.call(new Object[]{instance, teleportTransition});
    }

    @Inject(method={"handlePortal()V"}, at={@At(value="RETURN")})
    private void handlePortalChangeDimensionAfter(CallbackInfo ci) {
        this.portalId = null;
    }

    @Override
    public ResourceLocation worldportal$getPortalId() {
        return this.portalId;
    }

    @Override
    public PortalData worldportal$getPortal() {
        return PortalManager.getPortal(this.worldportal$getPortalId());
    }

    @Override
    public void worldportal$setPortal(ResourceLocation portalId) {
        this.portalId = portalId;
    }

    @Override
    public ResourceKey<Level> worldportal$setupPortal(BlockPos blockPos, ResourceKey<Level> originalKey) {
        Level level = this.level();
        BlockState blockState = level.getBlockState(blockPos);
        boolean hasHA = blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS);
        Direction.Axis axis = hasHA ? (Direction.Axis)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS) : Direction.Axis.X;
        BlockUtil.FoundRectangle foundRectangle = BlockUtil.getLargestRectangleAround((BlockPos)blockPos, (Direction.Axis)axis, (int)21, (Direction.Axis)(hasHA ? Direction.Axis.Y : Direction.Axis.Z), (int)21, blockPosX -> level.getBlockState(blockPosX) == blockState);
        BlockPos minCornerPos = foundRectangle.minCorner;
        ResourceLocation frameC1 = BuiltInRegistries.BLOCK.getKey((Object)level.getBlockState(minCornerPos.offset(axis == Direction.Axis.X ? foundRectangle.axis1Size : 0, hasHA ? -1 : 0, hasHA ? (axis == Direction.Axis.Z ? foundRectangle.axis1Size : 0) : -1)).getBlock());
        ResourceLocation frameC2 = BuiltInRegistries.BLOCK.getKey((Object)level.getBlockState(minCornerPos.offset(axis == Direction.Axis.X ? -1 : 0, hasHA ? -1 : 0, hasHA && axis != Direction.Axis.Z ? 0 : -1)).getBlock());
        ResourceLocation frameC3 = BuiltInRegistries.BLOCK.getKey((Object)level.getBlockState(minCornerPos.offset(axis == Direction.Axis.X ? foundRectangle.axis1Size : 0, hasHA ? foundRectangle.axis2Size : 0, hasHA ? (axis == Direction.Axis.Z ? foundRectangle.axis1Size : 0) : foundRectangle.axis2Size)).getBlock());
        ResourceLocation frameC4 = BuiltInRegistries.BLOCK.getKey((Object)level.getBlockState(minCornerPos.offset(axis == Direction.Axis.X ? -1 : 0, hasHA ? foundRectangle.axis2Size : 0, hasHA ? (axis == Direction.Axis.Z ? -1 : 0) : foundRectangle.axis2Size)).getBlock());
        HashMap portals = new HashMap();
        PortalManager.getPortals().forEach((k, v) -> {
            ResourceLocation mode = v.getModeLocation();
            if (hasHA ? mode != null && !mode.equals((Object)PortalData.DEFAULT_MODE) : mode == null || !mode.equals((Object)PortalData.HORIZONTAL_MODE)) {
                return;
            }
            ResourceLocation c1 = v.getFrameBottomLeftLocation();
            if (c1 != null && !frameC1.equals((Object)c1)) {
                return;
            }
            ResourceLocation c2 = v.getFrameBottomRightLocation();
            if (c2 != null && !frameC2.equals((Object)c2)) {
                return;
            }
            ResourceLocation c3 = v.getFrameTopLeftLocation();
            if (c3 != null && !frameC3.equals((Object)c3)) {
                return;
            }
            ResourceLocation c4 = v.getFrameTopRightLocation();
            if (c4 != null && !frameC4.equals((Object)c4)) {
                return;
            }
            portals.put(k, v);
        });
        ResourceKey resourceKeyX = level.dimension();
        IServerLevel serverLevelX = (IServerLevel)level;
        PortalReturns portalReturns = serverLevelX.worldportal$getPortalReturns();
        if (!portals.isEmpty()) {
            ResourceKey<Level> resourceKeyZ = portalReturns.getDimension(minCornerPos);
            if (resourceKeyZ != null) {
                for (Map.Entry entry : portals.entrySet()) {
                    ResourceKey<Level> resourceKey = ((PortalData)entry.getValue()).getDestinationKey();
                    if (resourceKeyX != resourceKey) continue;
                    this.worldportal$setPortal((ResourceLocation)entry.getKey());
                    return resourceKeyZ;
                }
            }
            Map<BlockPos, ResourceKey<Level>> dimensions = portalReturns.getDimensions();
            for (Map.Entry<BlockPos, ResourceKey<Level>> entry : dimensions.entrySet()) {
                BlockPos minCornerPosX = entry.getKey();
                if (blockPos.distSqr((Vec3i)minCornerPosX) > 128.0) continue;
                ResourceKey<Level> resourceKeyB = entry.getValue();
                for (Map.Entry entryX : portals.entrySet()) {
                    ResourceKey<Level> resourceKeyA = ((PortalData)entryX.getValue()).getDestinationKey();
                    if (resourceKeyX != resourceKeyA) continue;
                    portalReturns.putDimension(minCornerPos, resourceKeyB);
                    portalReturns.removeDimension(minCornerPosX);
                    this.worldportal$setPortal((ResourceLocation)entryX.getKey());
                    return resourceKeyB;
                }
            }
        }
        portals.keySet().removeIf(k -> resourceKeyX == ((PortalData)portals.get(k)).getDestinationKey());
        if (!portals.isEmpty()) {
            int random = level.getRandom().nextInt(portals.size());
            int i = 0;
            for (Map.Entry<Object, Object> entry : portals.entrySet()) {
                if (i != random) {
                    ++i;
                    continue;
                }
                ResourceKey<Level> resourceKeyZ = ((PortalData)entry.getValue()).getDestinationKey();
                if (resourceKeyZ == null) continue;
                this.worldportal$setPortal((ResourceLocation)entry.getKey());
                return resourceKeyZ;
            }
        }
        portalReturns.removeDimension(minCornerPos);
        return hasHA ? originalKey : null;
    }
}

