/*
 * Decompiled with CFR 0.152.
 */
package gay.object.hexdebug.api.client.splicing;

import at.petrak.hexcasting.api.casting.iota.IotaType;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import gay.object.hexdebug.HexDebug;
import gay.object.hexdebug.api.client.splicing.SplicingTableIotaRendererParser;
import gay.object.hexdebug.api.client.splicing.SplicingTableIotaRendererProvider;
import gay.object.hexdebug.resources.splicing.SplicingTableIotasResourceReloadListener;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SplicingTableIotaRenderers {
    private static final Map<ResourceLocation, SplicingTableIotaRendererParser<?>> PARSERS = Maps.newHashMap();

    public static void register(@NotNull ResourceLocation parserId, @NotNull SplicingTableIotaRendererParser<?> parser) {
        if (PARSERS.containsKey(parserId)) {
            HexDebug.LOGGER.warn("Overriding existing splicing table iota renderer parser: {}", (Object)parserId);
        }
        PARSERS.put(parserId, parser);
    }

    @NotNull
    public static SplicingTableIotaRendererProvider loadProvider(@NotNull ResourceLocation providerId) {
        return SplicingTableIotasResourceReloadListener.loadProvider(providerId);
    }

    @NotNull
    public static SplicingTableIotaRendererProvider parseProvider(@NotNull JsonObject jsonObject) {
        return SplicingTableIotasResourceReloadListener.parseProvider(jsonObject);
    }

    @Nullable
    public static SplicingTableIotaRendererProvider getProvider(@Nullable IotaType<?> iotaType) {
        return SplicingTableIotaRenderers.getProvider(iotaType, true);
    }

    @Nullable
    public static SplicingTableIotaRendererProvider getProvider(@Nullable IotaType<?> iotaType, boolean useFallback) {
        return SplicingTableIotasResourceReloadListener.getProvider(iotaType, useFallback);
    }

    @ApiStatus.Internal
    @Nullable
    public static SplicingTableIotaRendererParser<?> getParser(@NotNull ResourceLocation parserId) {
        return PARSERS.get(parserId);
    }
}

