/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.client;

import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.EntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.LayerDefinitionsContext;
import fuzs.puzzleslib.api.core.v1.context.PackRepositorySourcesContext;
import fuzs.puzzleslib.api.resources.v1.PackResourcesHelper;
import fuzs.tinyskeletons.TinySkeletons;
import fuzs.tinyskeletons.client.init.ModModelLayers;
import fuzs.tinyskeletons.client.packs.BabySkeletonPackResources;
import fuzs.tinyskeletons.client.renderer.entity.BabyBoggedRenderer;
import fuzs.tinyskeletons.client.renderer.entity.BabySkeletonRenderer;
import fuzs.tinyskeletons.client.renderer.entity.BabyStrayRenderer;
import fuzs.tinyskeletons.client.renderer.entity.BabyWitherSkeletonRenderer;
import fuzs.tinyskeletons.init.ModRegistry;
import java.util.function.Supplier;
import net.minecraft.client.model.BoggedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.LayerDefinitions;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.renderer.entity.ArmorModelSet;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public class TinySkeletonsClient
implements ClientModConstructor {
    public void onRegisterEntityRenderers(EntityRenderersContext context) {
        context.registerEntityRenderer((EntityType)ModRegistry.BABY_SKELETON_ENTITY_TYPE.value(), BabySkeletonRenderer::new);
        context.registerEntityRenderer((EntityType)ModRegistry.BABY_WITHER_SKELETON_ENTITY_TYPE.value(), BabyWitherSkeletonRenderer::new);
        context.registerEntityRenderer((EntityType)ModRegistry.BABY_STRAY_ENTITY_TYPE.value(), BabyStrayRenderer::new);
        context.registerEntityRenderer((EntityType)ModRegistry.BABY_BOGGED_ENTITY_TYPE.value(), BabyBoggedRenderer::new);
        context.registerEntityRenderer((EntityType)ModRegistry.MUSHROOM_ENTITY_TYPE.value(), ThrownItemRenderer::new);
    }

    public void onRegisterLayerDefinitions(LayerDefinitionsContext context) {
        Supplier<LayerDefinition> skeletonLayer = () -> SkeletonModel.createBodyLayer().apply(HumanoidModel.BABY_TRANSFORMER);
        ArmorModelSet armorModelSet = HumanoidModel.createArmorMeshSet((CubeDeformation)LayerDefinitions.INNER_ARMOR_DEFORMATION, (CubeDeformation)LayerDefinitions.OUTER_ARMOR_DEFORMATION).map(meshDefinition -> LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32).apply(HumanoidModel.BABY_TRANSFORMER));
        context.registerLayerDefinition(ModModelLayers.BABY_SKELETON, skeletonLayer);
        TinySkeletonsClient.registerLayerDefinitions(context, ModModelLayers.BABY_SKELETON_ARMOR, (ArmorModelSet<LayerDefinition>)armorModelSet);
        context.registerLayerDefinition(ModModelLayers.BABY_STRAY, skeletonLayer);
        TinySkeletonsClient.registerLayerDefinitions(context, ModModelLayers.BABY_STRAY_ARMOR, (ArmorModelSet<LayerDefinition>)armorModelSet);
        context.registerLayerDefinition(ModModelLayers.BABY_STRAY_OUTER_LAYER, () -> LayerDefinition.create((MeshDefinition)HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.25f), (float)0.0f), (int)64, (int)32).apply(HumanoidModel.BABY_TRANSFORMER));
        MeshTransformer witherSkeletonTransformer = MeshTransformer.scaling((float)1.2f);
        context.registerLayerDefinition(ModModelLayers.BABY_WITHER_SKELETON, () -> ((LayerDefinition)skeletonLayer.get()).apply(witherSkeletonTransformer));
        TinySkeletonsClient.registerLayerDefinitions(context, ModModelLayers.BABY_WITHER_SKELETON_ARMOR, (ArmorModelSet<LayerDefinition>)armorModelSet.map(layerDefinition -> layerDefinition.apply(witherSkeletonTransformer)));
        context.registerLayerDefinition(ModModelLayers.BABY_BOGGED, () -> BoggedModel.createBodyLayer().apply(HumanoidModel.BABY_TRANSFORMER));
        TinySkeletonsClient.registerLayerDefinitions(context, ModModelLayers.BABY_BOGGED_ARMOR, (ArmorModelSet<LayerDefinition>)armorModelSet);
        context.registerLayerDefinition(ModModelLayers.BABY_BOGGED_OUTER_LAYER, () -> LayerDefinition.create((MeshDefinition)HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.2f), (float)0.0f), (int)64, (int)32).apply(HumanoidModel.BABY_TRANSFORMER));
    }

    @Deprecated(forRemoval=true)
    private static void registerLayerDefinitions(LayerDefinitionsContext context, ArmorModelSet<ModelLayerLocation> modelLayerSet, ArmorModelSet<LayerDefinition> layerDefinitionSet) {
        context.registerLayerDefinition((ModelLayerLocation)modelLayerSet.head(), () -> layerDefinitionSet.head());
        context.registerLayerDefinition((ModelLayerLocation)modelLayerSet.chest(), () -> layerDefinitionSet.chest());
        context.registerLayerDefinition((ModelLayerLocation)modelLayerSet.legs(), () -> layerDefinitionSet.legs());
        context.registerLayerDefinition((ModelLayerLocation)modelLayerSet.feet(), () -> layerDefinitionSet.feet());
    }

    public void onAddResourcePackFinders(PackRepositorySourcesContext context) {
        context.registerRepositorySource(PackResourcesHelper.buildClientPack((ResourceLocation)TinySkeletons.id("dynamically_copied_skeleton_textures"), BabySkeletonPackResources::new, (boolean)false));
    }
}

