/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.client.packs;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.blaze3d.platform.NativeImage;
import fuzs.puzzleslib.api.resources.v1.AbstractModPackResources;
import fuzs.tinyskeletons.client.renderer.entity.BabyBoggedRenderer;
import fuzs.tinyskeletons.client.renderer.entity.BabySkeletonRenderer;
import fuzs.tinyskeletons.client.renderer.entity.BabyStrayRenderer;
import fuzs.tinyskeletons.client.renderer.entity.BabyWitherSkeletonRenderer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class BabySkeletonPackResources
extends AbstractModPackResources {
    public static final ResourceLocation SKELETON_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/skeleton.png");
    public static final ResourceLocation WITHER_SKELETON_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/wither_skeleton.png");
    public static final ResourceLocation STRAY_SKELETON_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/stray.png");
    public static final ResourceLocation STRAY_CLOTHES_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/stray_overlay.png");
    public static final ResourceLocation BOGGED_SKELETON_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/bogged.png");
    public static final ResourceLocation BOGGED_OUTER_LAYER_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/bogged_overlay.png");
    private static final BiMap<ResourceLocation, ResourceLocation> BABY_SKELETON_LOCATIONS = ImmutableBiMap.of((Object)BabySkeletonRenderer.SKELETON_LOCATION, (Object)SKELETON_LOCATION, (Object)BabyWitherSkeletonRenderer.WITHER_SKELETON_LOCATION, (Object)WITHER_SKELETON_LOCATION, (Object)BabyStrayRenderer.STRAY_SKELETON_LOCATION, (Object)STRAY_SKELETON_LOCATION, (Object)BabyStrayRenderer.STRAY_CLOTHES_LOCATION, (Object)STRAY_CLOTHES_LOCATION, (Object)BabyBoggedRenderer.BOGGED_SKELETON_LOCATION, (Object)BOGGED_SKELETON_LOCATION, (Object)BabyBoggedRenderer.BOGGED_OUTER_LAYER_LOCATION, (Object)BOGGED_OUTER_LAYER_LOCATION);
    private static final int VANILLA_SKELETON_TEXTURE_WIDTH = 64;
    private static final int VANILLA_SKELETON_TEXTURE_HEIGHT = 32;
    private final ResourceManager resourceManager;
    private final VanillaPackResources vanillaPackResources;

    public BabySkeletonPackResources() {
        Minecraft minecraft = Minecraft.getInstance();
        this.resourceManager = minecraft.getResourceManager();
        this.vanillaPackResources = minecraft.getVanillaPackResources();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public IoSupplier<InputStream> getResource(PackType packType, ResourceLocation location) {
        ResourceLocation vanillaSkeletonLocation = (ResourceLocation)BABY_SKELETON_LOCATIONS.get((Object)location);
        if (vanillaSkeletonLocation == null) {
            return null;
        }
        Optional resource = this.resourceManager.getResource(vanillaSkeletonLocation);
        if (!resource.isPresent()) return null;
        try (NativeImage nativeImage = NativeImage.read((InputStream)((Resource)resource.get()).open());){
            if (nativeImage.getWidth() / nativeImage.getHeight() == 2) return () -> ((Resource)((Resource)resource.get())).open();
            IoSupplier ioSupplier = this.vanillaPackResources.getResource(packType, vanillaSkeletonLocation);
            return ioSupplier;
        }
        catch (IOException iOException) {
        }
        return () -> ((Resource)((Resource)resource.get())).open();
    }

    public Set<String> getNamespaces(PackType type) {
        return BABY_SKELETON_LOCATIONS.keySet().stream().map(ResourceLocation::getNamespace).collect(Collectors.toSet());
    }
}

