/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.tinyskeletons.client.renderer.entity.state.BabyWitherSkeletonRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionfc;

public class SkullInHandLayer<S extends BabyWitherSkeletonRenderState, M extends EntityModel<S>>
extends ItemInHandLayer<S, M> {
    private final BlockRenderDispatcher blockRenderer;

    public SkullInHandLayer(RenderLayerParent<S, M> renderLayerParent, BlockRenderDispatcher blockRenderer) {
        super(renderLayerParent);
        this.blockRenderer = blockRenderer;
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int packedLight, S renderState, float yRot, float xRot) {
        ItemStack itemStack = ((BabyWitherSkeletonRenderState)((Object)renderState)).skullItem;
        Item item = itemStack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            this.submitHandSkullItem(blockItem.getBlock().defaultBlockState(), poseStack, submitNodeCollector, packedLight, renderState);
        } else {
            super.submit(poseStack, submitNodeCollector, packedLight, renderState, yRot, xRot);
        }
    }

    private void submitHandSkullItem(BlockState blockState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int packedLight, S renderState) {
        poseStack.pushPose();
        poseStack.translate(0.0f, -0.075f, 0.325f);
        poseStack.translate(0.0f, 0.6875f, -0.75f);
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(20.0f));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
        poseStack.translate(0.25f, 0.1875f, 0.25f);
        poseStack.scale(-0.5f, -0.5f, 0.5f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
        submitNodeCollector.submitBlock(poseStack, blockState, packedLight, OverlayTexture.NO_OVERLAY, ((BabyWitherSkeletonRenderState)((Object)renderState)).outlineColor);
        poseStack.popPose();
    }
}

