/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.handler;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.util.v1.EntityHelper;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BabyConversionHandler {
    private static final Map<EntityType<? extends Mob>, EntityType<? extends Mob>> BABY_MOB_CONVERSIONS = new HashMap<EntityType<? extends Mob>, EntityType<? extends Mob>>();

    public static void registerConversion(EntityType<? extends Mob> targetMob, EntityType<? extends Mob> convertsTo) {
        BABY_MOB_CONVERSIONS.put(targetMob, convertsTo);
    }

    public static EventResult onEntityLoad(Entity entity, ServerLevel serverLevel, boolean isNewlySpawned) {
        EntityType<? extends Mob> entityType;
        @Nullable EntitySpawnReason entitySpawnReason = EntityHelper.getMobSpawnReason((Entity)entity);
        if (isNewlySpawned && entitySpawnReason != null && entitySpawnReason != EntitySpawnReason.COMMAND && Zombie.getSpawnAsBabyOdds((RandomSource)serverLevel.getRandom()) && (entityType = BABY_MOB_CONVERSIONS.get(entity.getType())) != null && BabyConversionHandler.createAndSpawnBabyMob(serverLevel, entityType, entity, entitySpawnReason) != null) {
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    public static EventResultHolder<InteractionResult> onEntityInteract(Player player, Level level, InteractionHand interactionHand, Entity target, Vec3 hitVector) {
        EntityType eggType;
        EntityType<? extends Mob> babyType;
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        if (target.isAlive() && itemInHand.getItem() instanceof SpawnEggItem && (babyType = BABY_MOB_CONVERSIONS.get(eggType = ((SpawnEggItem)itemInHand.getItem()).getType(itemInHand))) != null && (target.getType() == babyType || target.getType() == eggType)) {
            Mob mob;
            if (!level.isClientSide() && (mob = BabyConversionHandler.createAndSpawnBabyMob((ServerLevel)level, babyType, target, EntitySpawnReason.SPAWN_ITEM_USE)) != null) {
                BabyConversionHandler.finalizeSpawnEggMob(mob, itemInHand, player);
            }
            return EventResultHolder.interrupt((Object)InteractionResultHelper.sidedSuccess((boolean)level.isClientSide()));
        }
        return EventResultHolder.pass();
    }

    private static void finalizeSpawnEggMob(Mob mob, ItemStack itemStack, Player player) {
        mob.playAmbientSound();
        if (itemStack.has(DataComponents.CUSTOM_NAME)) {
            mob.setCustomName(itemStack.getHoverName());
        }
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
    }

    @Nullable
    private static Mob createAndSpawnBabyMob(ServerLevel serverLevel, EntityType<? extends Mob> entityType, Entity parent, EntitySpawnReason entitySpawnReason) {
        Mob mob;
        if (parent instanceof AgeableMob) {
            AgeableMob ageableMob = (AgeableMob)parent;
            mob = ageableMob.getBreedOffspring(serverLevel, ageableMob);
        } else {
            mob = (Mob)entityType.create((Level)serverLevel, entitySpawnReason);
        }
        if (mob == null) {
            return null;
        }
        Preconditions.checkState((boolean)mob.isBaby(), (Object)"Baby mob must be a baby by default");
        mob.snapTo(parent.getX(), parent.getY(), parent.getZ(), Mth.wrapDegrees((float)(serverLevel.random.nextFloat() * 360.0f)), 0.0f);
        mob.yHeadRot = mob.getYRot();
        mob.yBodyRot = mob.getYRot();
        DifficultyInstance difficulty = serverLevel.getCurrentDifficultyAt(parent.blockPosition());
        mob.finalizeSpawn((ServerLevelAccessor)serverLevel, difficulty, entitySpawnReason, null);
        serverLevel.addFreshEntityWithPassengers((Entity)mob);
        return mob;
    }
}

