/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.world.entity.monster;

import fuzs.tinyskeletons.world.entity.monster.projectile.Mushroom;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.Bogged;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BabyBogged
extends Bogged {
    public BabyBogged(EntityType<? extends Bogged> entityType, Level level) {
        super(entityType, level);
        this.xpReward = (int)((float)this.xpReward * 2.5f);
        this.refreshDimensions();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 30, 15.0f){

            public boolean canUse() {
                return super.canUse() && BabyBogged.this.getMainHandItem().isEmpty();
            }
        });
        super.registerGoals();
    }

    public float getPickRadius() {
        return 0.3f;
    }

    public boolean isBaby() {
        return true;
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).withEyeHeight(this.getType().getDimensions().eyeHeight() * (this.isBaby() ? 0.534f : 1.0f));
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
    }

    public void reassessWeaponGoal() {
    }

    public void performRangedAttack(LivingEntity target, float velocity) {
        double dX = target.getX() - this.getX();
        double dY = target.getEyeY() - (double)1.1f;
        double dZ = target.getZ() - this.getZ();
        double g = Math.sqrt(dX * dX + dZ * dZ) * (double)0.2f;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack itemStack = new ItemStack((ItemLike)(this.random.nextBoolean() ? Items.RED_MUSHROOM : Items.BROWN_MUSHROOM));
            Projectile.spawnProjectile((Projectile)new Mushroom((Level)serverLevel, (LivingEntity)this, itemStack), (ServerLevel)serverLevel, (ItemStack)itemStack, snowball -> snowball.shoot(dX, dY + g - snowball.getY(), dZ, 1.6f, 14.0f - (float)serverLevel.getDifficulty().getId() * 2.0f));
        }
        this.playSound(SoundEvents.SNOW_GOLEM_SHOOT, 1.0f, 0.4f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.swing(InteractionHand.MAIN_HAND);
    }
}

