/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.world.entity.monster;

import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import fuzs.tinyskeletons.world.entity.monster.SkullCarryingMob;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BabyWitherSkeleton
extends WitherSkeleton
implements SkullCarryingMob {
    private final AvoidEntityGoal<Player> fleePlayerGoal = new AvoidEntityGoal((PathfinderMob)this, Player.class, 6.0f, 1.0, 1.2);
    private int dancingTicks;

    public BabyWitherSkeleton(EntityType<? extends WitherSkeleton> entityType, Level level) {
        super(entityType, level);
        this.xpReward = (int)((float)this.xpReward * 2.5f);
        this.refreshDimensions();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.goalSelector.addGoal(3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, IronGolem.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public float getPickRadius() {
        return 0.35f;
    }

    public void aiStep() {
        super.aiStep();
        if (this.dancingTicks > 0) {
            --this.dancingTicks;
        }
    }

    public void reassessWeaponGoal() {
        if (this.level() != null && !this.level().isClientSide()) {
            this.goalSelector.removeGoal(this.fleePlayerGoal);
            if (!this.getSkullItem().isEmpty()) {
                this.goalSelector.addGoal(3, this.fleePlayerGoal);
            }
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        ItemStack skullItem;
        ItemStack itemstack = player.getItemInHand(interactionHand);
        if (itemstack.is(Items.WITHER_ROSE) && !(skullItem = this.getSkullItem()).isEmpty()) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                this.spawnAtLocation(serverLevel, skullItem);
                this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            }
            this.setDancing();
            return InteractionResultHelper.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.mobInteract(player, interactionHand);
    }

    private void setDancing() {
        this.dancingTicks = 300;
    }

    @Override
    public boolean isDancing() {
        return this.dancingTicks > 0;
    }

    public boolean isBaby() {
        return true;
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).withEyeHeight(this.getType().getDimensions().eyeHeight() * (this.isBaby() ? 0.534f : 1.0f));
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.WITHER_SKELETON_SKULL));
        this.setGuaranteedDrop(EquipmentSlot.MAINHAND);
    }

    @Override
    public ItemStack getSkullItem() {
        if (this.isOnlyCarryingSkull((LivingEntity)this, InteractionHand.MAIN_HAND)) {
            return this.getMainHandItem();
        }
        if (this.isOnlyCarryingSkull((LivingEntity)this, InteractionHand.OFF_HAND)) {
            return this.getOffhandItem();
        }
        return ItemStack.EMPTY;
    }
}

